@REM 
@REM Author: Jerome Fimes
@REM Version: 03-10-2014 v1.0
@REM Creation of a self signed certificate
@REM

@echo off
REM Make sure openssl is in the current folder and with required files

echo.
echo Certificate / Private key batch generator
echo Copyright RealFusio 2018
echo.


call :file_name_from_path currentFolder "%0"

set "openssl=%currentFolder%openssl.exe"
set "openssl_cnf=%currentFolder%openssl.cnf"

pushd %currentFolder%

if not exist "%openssl%" (
	echo openssl binary does not exist
	popd
	pause
	exit /B 1
)
if not exist "%openssl_cnf%" (
	echo openssl configuration file does not exist
	popd
	pause
	exit /B 1
)

REM ask for the filenames
set /p certificateName=Please provide the filename for your new certificate [server.crt]:
if [%certificateName%] == [] set certificateName=server.crt

set /p keyName=Please provide the filename for your new private key file [private.key]:
if [%keyName%] == [] set keyName=private.key

REM Get a temp file
call :get_temp_name tmpfile

REM set config file for openssl
set "OPENSSL_CONF=%openssl_cnf%"

REM Create the private key
"%openssl%" genrsa -out "%keyName%" 2048 > nul 2>&1
if %ERRORLEVEL% NEQ 0 (
	echo Could not create private key, exiting
	popd
	pause
	exit /B 1
)


echo.
echo.
echo.

REM Create the csr request
"%openssl%" req -new -key "%keyName%" -out "%tmpfile%"
if %ERRORLEVEL% NEQ 0 (
	del %tmpfile%
	echo Could not create certificate signing request, exiting
	popd
	pause
	exit /B 1
)

"%openssl%" x509 -req -days 3650 -sha256 -in "%tmpfile%" -signkey "%keyName%" -out "%certificateName%" > nul 2>&1
del %tmpfile%

echo.
echo.
echo.

REM restore old folder
popd
echo Certicate / Key generation successful
echo.
echo.

REM exit
pause
exit /B 0

REM Gets the a temp name and stores it in a variable
:get_temp_name <resultVar>
(
	set "%~1=%TMP%\ssltmpfile-%RANDOM%.tmp"
	if exist "%~1" GOTO :get_temp_name
	exit /b
)

REM Gets the folder part of a filename
:file_name_from_path <resultVar> <pathVar>
(
    set "%~1=%~dp1"
    exit /b
)
