// This program belongs to AKKODIS INGENIERIE PRODUIT SAS.
// It is considered a trade secret, and is not to be divulged or used 
// by parties who have not received written authorization from the owner.
//
// This package includes the opentype.js library, licensed under the MIT license terms.
// This package includes the bowser library, licensed under the MIT license terms.
// This package includes the ajv library (https://ajv.js.org/), licensed under the MIT license terms.
// 
// The MIT License (MIT)
// Copyright (c) 2017 Frederik De Bleser
// Permission is hereby granted, free of charge, to any person obtaining a copy of
// this software and associated documentation files (the "Software"), to deal in
// the Software without restriction, including without limitation the rights to
// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
// the Software, and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
// FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
// COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
// IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// This package includes the luxon library, licensed under the JS Foundation license.
// 
// Copyright 2019 JS Foundation and other contributors
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
// The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
// 
// package			: infiniteapi
// author			: 3djuump
// date				: $IntDate$
// Last revision	: Rev: $Revision$
//

window.onload = function() {
    /* eslint-disable no-console */
    /* eslint-disable no-plusplus */
    /* eslint-disable prefer-template */
    /* eslint-disable guard-for-in */
    // ####################################################################################################################################
    // ###########################  Sample to illustrate the use of the 3d juump infinite javascript API ##################################
    // ####################################################################################################################################
    // this sample illustrates the use of the 3djuump API.
    // It covers :
    // * basic object creation (use of factories)
    // * authentication
    // * 3d picking
    // * visibility management : ghost, selected, hidden, change of material
    // * keyboard keys are registered as follows :
    //    - space : reset camera and reset visual state (clear selection / ghost state)
    //    - F : cycle through some filtering / metadata tests
    //    - C : cycle through available configurations
    //    - S : trigger a search for "roue"
    //    - X : change the material of the last clicked geometry (red)
    // helper function to format Date to string
    function HumanizeDate(pDate) {
        var options = { hour12: false, month: 'short', day: 'numeric', hour: '2-digit', minute: '2-digit' };
        var lCurrentDate = new Date();
        if (lCurrentDate.getFullYear() !== pDate.getFullYear()) {
            options.year = 'numeric';
        }
        var lFormat = new Intl.DateTimeFormat('en-US', options);
        return lFormat.format(pDate);
    }
    // the build id of the opened data session (DataSessionInterface)
    var sBuildId = '';
    // the material id is used to test the material manager (MaterialManagerInterface)
    var lRedMaterialId = 0;
    // the geometric instance id that was clicked previously
    var lLastClickedGeometricInstanceId = 0;
    // the geometric instance id that had its material overridden (0 is none) 
    var lLastMaterialGeometricInstanceId = 0;
    // is the DMU loaded at the moment ?
    var lDMULoaded = false;
    // the material ids for the primitives (box, lines, points)
    // let lPrimitiveMaterialIds: number[] = [0, 0, 0, 0];
    // what to do when we have the result from a pick ?
    var onPicking;
    // when the configuration is computed : hide all but the instances inside the given configuration
    var onConfCtxReady;
    // select items that are in the solver
    var onGlobalSolverReady;
    // Failed callback on openDb
    var onOpenDBFailed;
    // when the search is over, ghost everyone except the one inside the search result
    // and convert document ids to part instance ids
    var onSearchReady;
    // we get the part instance ids from the search, do nothing but convert to geometric instance ids
    var onDocumentIdConverterReady;
    // when the document id is cancelled (not likely wince we do not call DocumentIdConverterInterface.cancel)
    var onDocumentIdConverterCancelled;
    // Success callback on openDb
    var onOpenDBSuccess;
    // we have the geometric instance ids of first item of the search
    var onPartInstanceConverterReady;
    // we have the part instance ids of first item of the search, again, this is a dumb test
    // only for illustration purpose : do not make such things in production !!!
    var onGeometricInstanceConverterReady;
    var onGetIdCardSuccess;
    // On selected project changed
    var onProjectSelectedChanged;
    // Success callback on close database
    var onCloseDBSuccess;
    // ####################################################################################################################################
    // ############################################  BROWSER INFOS  #######################################################################
    // ####################################################################################################################################
    // do not need at the moment (perhaps in future versions)
    // let lBrowser: Browser = BrowserDetector.GetBrowser();
    // ####################################################################################################################################
    // ############################################  ENGINE  #############################################################################
    // ####################################################################################################################################
    // use of a cache to lower the network and bandwidth use
    var lCache = undefined;
    // the main object of the 3d juump API, 
    var lMetadataManager = infiniteapi.MetadataManagerFactory.CreateMetadataManager();
    var lInfiniteEngine = undefined;
    var lView3D = document.getElementById('rendering');
    // creates an engine, you may return undefined to test the use of the API without a 3d window 
    var createEngine = function (pMetadataManager) {
        if (!lCache) {
            // use of a cache to lower the network and bandwidth use
            lCache = infiniteapi.InfiniteCacheFactory.CreateInfiniteCache();
        }
        if (!lInfiniteEngine) {
            lInfiniteEngine = infiniteapi.InfiniteFactory.CreateInfiniteEngine(pMetadataManager);
            if (lInfiniteEngine) {
                // bind the rendering to the given div
                lInfiniteEngine.setView(lView3D);
                // and use anti-aliasing => smoother
                lInfiniteEngine.enableAntiAliasing(true);
                // register the callback for pick result
                lInfiniteEngine.addEventListener(infiniteapi.InfiniteEngineInterfaceSignal.Picked, onPicking);
            }
        }
        // return undefined;
    };
    // ######################################################################################################################
    // ############################################     LOADING     #########################################################
    // ######################################################################################################################
    // create a new session on the directory
    var lDirectorySession = infiniteapi.DirectorySessionFactory.CreateDirectorySession(lMetadataManager, window['sDirectoryUrl']);
    // and this will be the data session opened on a specific 3d juump infinite proxy
    var lDataSession;
    // what to do when the DMU is loaded ?
    var onDMULoaded = function (_pEvent, _pCallbackData) {
        // hide loader frame
        var lLoader = document.getElementById('loaderFrame');
        lLoader.style.display = 'none';
        if (lInfiniteEngine) {
            // create a new material to change instance color
            lRedMaterialId = lInfiniteEngine.getMaterialManager().createNewMaterial(new infiniteapi.Vector3(1, 0, 0));
            // create a red and black materials to be used with points and the like
            // lPrimitiveMaterialIds[0] = lInfiniteEngine.getPrimitiveManager().getMaterialManager().createMaterial(new Vector4(1, 0, 0, 1));
            // lPrimitiveMaterialIds[1] = lInfiniteEngine.getPrimitiveManager().getMaterialManager().createMaterial(new Vector4(0, 0, 0, 1));
            // lPrimitiveMaterialIds[2] = lInfiniteEngine.getPrimitiveManager().getMaterialManager().createMaterial(new Vector4(1, 1, 1, 0.90));
            // lPrimitiveMaterialIds[3] = lInfiniteEngine.getPrimitiveManager().getMaterialManager().createMaterial(new Vector4(1, 1, 1, 0.25));
        }
        lDMULoaded = true;
    };
    var sValue = 0;
    var lStartFrame;
    var lSelector;
    var lLoginFrame;
    // what to do when the DMU loading failed ?
    var onDMULoadingFailed = function (_pEvent, _pCallbackData) {
        lView3D.style.display = 'none';
        lStartFrame.style.display = 'block';
        lSelector.style.display = 'none';
        lLoginFrame.style.display = 'block';
        var lLoader = document.getElementById('loaderFrame');
        lLoader.style.display = 'none';
        var lReset = document.getElementById('resetbutton');
        lReset.style.display = 'none';
        var lResource = document.getElementById('rcDiv');
        lResource.style.display = 'none';
        lDMULoaded = false;
        console.log('loading failed ' + (sValue++).toString());
    };
    // ####################################################################################################################################
    // ############################################  Metadata test  #######################################################################
    // ####################################################################################################################################
    var sNbTests = 4;
    // Class to test multiple metadata functions 
    var TestMetadata = /** @class */ (function () {
        function TestMetadata() {
            // set everyone the undefined
            this.mConfCtx = undefined;
            this.mGlobalVisibilityCtx = undefined;
            this.mSearchVisibilityCtx = undefined;
            this.mConfVisibilityCtx = undefined;
            this.mGlobalSolver = undefined;
            this.mSearchSolver = undefined;
            this.mPartFilter = undefined;
            this.mBoxFilter = undefined;
            this.mAttributeFilter1 = undefined;
            this.mAttributeFilter2 = undefined;
            this.mSearch = undefined;
            this.mDocumentIdConverter = undefined;
            this.mPartInstanceConverter = undefined;
            this.mGeometricInstanceConverter = undefined;
            this.mGeometricConverterForIdCard = undefined;
            this.mCurrentConfOffset = -1;
            this.mTestNb = 3;
        }
        TestMetadata.prototype.clearMetadata = function () {
            // cleanup : remove items that are no more in use
            // please pay attention to make the actual cleanup 
            // since it will be more efficient later on
            if (this.mPartFilter) {
                this.mPartFilter.dispose();
                this.mPartFilter = undefined;
            }
            if (this.mBoxFilter) {
                this.mBoxFilter.dispose();
                this.mBoxFilter = undefined;
            }
            if (this.mAttributeFilter1) {
                this.mAttributeFilter1.dispose();
                this.mAttributeFilter1 = undefined;
            }
            if (this.mAttributeFilter2) {
                this.mAttributeFilter2.dispose();
                this.mAttributeFilter2 = undefined;
            }
            if (this.mConfCtx) {
                this.mConfCtx.dispose();
                this.mConfCtx = undefined;
            }
            if (this.mGlobalSolver) {
                this.mGlobalSolver.dispose();
                this.mGlobalSolver = undefined;
            }
            if (this.mSearchSolver) {
                this.mSearchSolver.dispose();
                this.mSearchSolver = undefined;
            }
            // at the moment, not all the objects can be reclaimed, future versions of the API will 
            // allow reclaiming these objects
            this.mGlobalVisibilityCtx = undefined;
            this.mConfVisibilityCtx = undefined;
            this.mSearchVisibilityCtx = undefined;
            this.mSearch = undefined;
            this.mDocumentIdConverter = undefined;
            this.mPartInstanceConverter = undefined;
            this.mGeometricInstanceConverter = undefined;
            this.mGeometricConverterForIdCard = undefined;
            this.mTestNb = 3;
            this.mCurrentConfOffset = -1;
        };
        TestMetadata.prototype.initCtx = function (pDataSession) {
            if (!this.mConfCtx) {
                // create the configuration part (dual confContextInterface / VisibilityContextInterface)
                this.mConfCtx = pDataSession.createConfContext();
                this.mConfVisibilityCtx = pDataSession.createVisibilityContext();
                // link them
                this.mConfVisibilityCtx.setConfContext(this.mConfCtx);
                // and hide geometric instances that are not in the current configuration (see onConfCtxReady)
                this.mConfCtx.addEventListener(infiniteapi.ConfContextInterfaceSignal.ConfContextReady, onConfCtxReady);
                // create the "current visibility" part (dual FilterSolverInterface / VisibilityContextInterface)
                this.mGlobalVisibilityCtx = pDataSession.createVisibilityContext();
                // use this conf context
                this.mGlobalVisibilityCtx.setConfContext(this.mConfCtx);
                this.mGlobalSolver = pDataSession.createFilterSolver();
                this.mGlobalVisibilityCtx.insertFilterSolver(0, this.mGlobalSolver);
                // solver works on the configuration VisibilityContextInterface
                this.mGlobalSolver.setVisibilityContext(this.mConfVisibilityCtx);
                // set the parts of the filters as "selected" (see onGlobalSolverReady)
                this.mGlobalSolver.addEventListener(infiniteapi.FilterSolverInterfaceSignal.SolverReady, onGlobalSolverReady);
                // create the "search" part that works on the current configuration (dual FilterSolverInterface / VisibilityContextInterface)
                this.mSearchVisibilityCtx = pDataSession.createVisibilityContext();
                // use this conf context
                this.mSearchVisibilityCtx.setConfContext(this.mConfCtx);
                this.mSearchSolver = pDataSession.createFilterSolver();
                this.mSearchVisibilityCtx.insertFilterSolver(0, this.mSearchSolver);
                // solver works on the configuration VisibilityContextInterface
                this.mSearchSolver.setVisibilityContext(this.mConfVisibilityCtx);
                // do not filter more than the current configuration (you may customize to see the result)
                var lAllPartInstanceFilter = pDataSession.createFilterAllParts();
                this.mSearchSolver.insertFilter(0, lAllPartInstanceFilter);
                // make some optimization to speed up and lower bandwidth : do not get the part instance ids, only retrieve geometric instance ids
                this.mSearchSolver.setRetrievePartInstanceIds(false);
                // create a search object
                this.mSearch = pDataSession.createSearch();
                this.mSearch.addEventListener(infiniteapi.SearchInterfaceSignal.SearchReady, onSearchReady);
                // and some converters
                this.mDocumentIdConverter = pDataSession.createDocumentIdConverter();
                this.mDocumentIdConverter.addEventListener(infiniteapi.DocumentIdConverterInterfaceSignal.DocumentIdConverterReady, onDocumentIdConverterReady);
                this.mDocumentIdConverter.addEventListener(infiniteapi.DocumentIdConverterInterfaceSignal.DocumentIdConverterCancelled, onDocumentIdConverterCancelled);
                this.mPartInstanceConverter = pDataSession.createPartInstanceConverter();
                this.mPartInstanceConverter.addEventListener(infiniteapi.PartInstanceConverterInterfaceSignal.PartInstanceConverterReady, onPartInstanceConverterReady);
                this.mGeometricInstanceConverter = pDataSession.createGeometricInstanceConverter();
                this.mGeometricInstanceConverter.addEventListener(infiniteapi.GeometricInstanceConverterInterfaceSignal.GeometricInstanceConverterReady, onGeometricInstanceConverterReady);
                this.mGeometricConverterForIdCard = pDataSession.createGeometricInstanceConverter();
                {
                    var lGeometricInstanceConverter_1 = this.mGeometricConverterForIdCard;
                    var lConfVisibility_1 = this.mConfVisibilityCtx;
                    // when we have converted geometric instance id => part instance id, we retrieve the id card
                    this.mGeometricConverterForIdCard.addEventListener(infiniteapi.GeometricInstanceConverterInterfaceSignal.GeometricInstanceConverterReady, function () {
                        if (lGeometricInstanceConverter_1.getLastError().length === 0) {
                            // show the id card content when the conversion is over
                            var lPartInstanceIds = lGeometricInstanceConverter_1.getPartInstanceIds();
                            var lIdCardGetter = pDataSession.createIdCardGetter();
                            lIdCardGetter.addEventListener(infiniteapi.IdCardGetterInterfaceSignal.IdCardReady, function (pEvent) {
                                var lInnerIdCardGetter = pEvent.emitter;
                                if (lInnerIdCardGetter.getLastError().length === 0) {
                                    var lPartInstanceInfos = lInnerIdCardGetter.getPartInstanceInfos();
                                    if ((lPartInstanceInfos !== undefined) && (lPartInstanceInfos.length !== 0)) {
                                        onGetIdCardSuccess(lPartInstanceInfos[0].getIdCardHierarchy());
                                    }
                                }
                                else {
                                    console.log('IdCard: ' + lInnerIdCardGetter.getLastError());
                                }
                            });
                            lIdCardGetter.retrieveIdCard(lPartInstanceIds, lConfVisibility_1);
                        }
                    });
                }
                pDataSession.update();
            }
        };
        // we will only select the item(s) that have the instance id window["test"]["partInstanceListFilter"]["value"] 
        // (you may want to get the ones you want)
        TestMetadata.prototype.testPartFilter = function (pDataSession) {
            // init the context just in case
            this.initCtx(pDataSession);
            if (!this.mPartFilter) {
                // filter with only one part instance : part instance id window["test"]["partInstanceListFilter"]["value"];
                this.mPartFilter = pDataSession.createFilterPartInstanceList();
                var lData = new Uint32Array(1);
                lData[0] = window['test']['partInstanceListFilter']['value'];
                this.mPartFilter.setPartInstanceList(lData, sBuildId);
            }
            var lSolver = this.mGlobalSolver;
            // do not get part instance ids in the result of the FilterSolverInterface to lower
            // bandwidth usage
            lSolver.setRetrievePartInstanceIds(false);
            // only one filter : the part instance id filter
            lSolver.removeAllFilters();
            lSolver.insertFilter(0, this.mPartFilter);
            // we have modified a "metadata" object, tells the metadataManagerInterface
            // to trigger a calculation
            // do NOT FORGET to call the update() method !!!! 
            pDataSession.update();
        };
        // we will only select the item(s) that are strictly included in a given box :
        // we create a box centered on (1234, 0, 734) with HALF extent 1500, 1500, 1500, thus if the DMU is in millimeters :
        // a box of 3 meters in each direction
        TestMetadata.prototype.testBoxFilter = function (pDataSession) {
            // init the context just in case
            this.initCtx(pDataSession);
            if (!this.mBoxFilter) {
                this.mBoxFilter = pDataSession.createFilterAABB();
                // create a box filter centered on 1234, 0, 734 with half extent 1500, 1500, 1500
                var lCenter = window['test']['boxFilter']['center'];
                var lBoxHalfExtent = window['test']['boxFilter']['half_extent'];
                this.mBoxFilter.setAABB(new infiniteapi.AABB(new infiniteapi.Vector3(lCenter[0], lCenter[1], lCenter[2]), new infiniteapi.Vector3(lBoxHalfExtent[0], lBoxHalfExtent[1], lBoxHalfExtent[2])));
                // select only part that are strictly included inside this box
                this.mBoxFilter.setOverlapped(false);
            }
            var lSolver = this.mGlobalSolver;
            // only one filter : the box filter
            lSolver.removeAllFilters();
            lSolver.insertFilter(0, this.mBoxFilter);
            // we have modified a "metadata" object, tells the metadataManagerInterface
            // to trigger a calculation
            // do NOT FORGET to call the update() method !!!! 
            pDataSession.update();
        };
        // we will only select items that have a metadata of type string.
        // in this sample, the metadata "system" is a string metadata
        // we will select items that have the "system" attribute exactly equal to "4000-Inter"
        TestMetadata.prototype.testAttributeFilter1 = function (pDataSession) {
            // init the context just in case
            this.initCtx(pDataSession);
            if (!this.mAttributeFilter1) {
                this.mAttributeFilter1 = pDataSession.createFilterAttribute();
                // filter by attribute "system" that is equal to "4000-Inter"
                this.mAttributeFilter1.setAttributeName(window['test']['attributeFilterExact']['attributeName']);
                this.mAttributeFilter1.setExactValues(window['test']['attributeFilterExact']['values']);
                // and filter out N/A values (i.e. parts that have not the "system" attribute)
                this.mAttributeFilter1.setNaValueChecked(false);
            }
            var lSolver = this.mGlobalSolver;
            // only one filter : the FilterAttributeInterface
            lSolver.removeAllFilters();
            lSolver.insertFilter(0, this.mAttributeFilter1);
            // we have modified a "metadata" object, tells the metadataManagerInterface
            // to trigger a calculation
            // do NOT FORGET to call the update() method !!!! 
            pDataSession.update();
        };
        // we will only select items that have NOT a metadata of type string.
        // in this sample, the metadata "Name" is a string metadata
        // we will select items that have the not their "Name" attribute that contains "elec" or "Train AV Link&Go"
        TestMetadata.prototype.testAttributeFilter2 = function (pDataSession) {
            // init the context just in case
            this.initCtx(pDataSession);
            if (!this.mAttributeFilter2) {
                this.mAttributeFilter2 = pDataSession.createFilterAttribute();
                // items that have NOT a metadata => inverted filter
                this.mAttributeFilter2.setInverted(true);
                // we will want to work on contains value : N/A should be disabled (see documentation)
                this.mAttributeFilter2.setNaValueActivated(false);
                // work on attribute "Name"
                this.mAttributeFilter2.setAttributeName(window['test']['attributeFilterContains']['attributeName']);
                // that do NOT contain "elec" or "Train AV Link&Go"
                this.mAttributeFilter2.setContainsValues(window['test']['attributeFilterContains']['values']);
            }
            var lSolver = this.mGlobalSolver;
            // only one filter : the FilterAttributeInterface
            lSolver.removeAllFilters();
            lSolver.insertFilter(0, this.mAttributeFilter2);
            // we have modified a "metadata" object, tells the metadataManagerInterface
            // to trigger a calculation
            // do NOT FORGET to call the update() method !!!! 
            pDataSession.update();
        };
        // Cycle on the different tests
        TestMetadata.prototype.testCtx = function (pDataSession) {
            switch (this.mTestNb) {
                case 0:
                    this.testPartFilter(pDataSession);
                    break;
                case 1:
                    this.testBoxFilter(pDataSession);
                    break;
                case 2:
                    this.testAttributeFilter1(pDataSession);
                    break;
                case 3:
                    this.testAttributeFilter2(pDataSession);
                    break;
                default:
                    break;
            }
            ++this.mTestNb;
            if (this.mTestNb === sNbTests) {
                this.mTestNb = 0;
            }
        };
        // cycle on the available configurations :
        TestMetadata.prototype.nextConfCtx = function (pDataSession) {
            // init the context just in case
            this.initCtx(pDataSession);
            // get the available configurations :
            var lConfigurations = pDataSession.getConfigurationList();
            // cycle
            ++this.mCurrentConfOffset;
            if (this.mCurrentConfOffset >= lConfigurations.length) {
                this.mCurrentConfOffset = -1;
            }
            var lConfCtx = (this.mConfCtx);
            if (this.mCurrentConfOffset < 0) {
                // unconfigured
                lConfCtx.setActiveConfs([]);
            }
            else {
                // set the configuration to use
                lConfCtx.setActiveConfs([lConfigurations[this.mCurrentConfOffset].getConfigurationId()]);
            }
            // we have modified a "metadata" object, tells the metadataManagerInterface
            // to trigger a calculation
            // do NOT FORGET to call the update() method !!!! 
            pDataSession.update();
        };
        // trigger a search
        TestMetadata.prototype.search = function (pQuery, pDataSession) {
            // init the context just in case
            this.initCtx(pDataSession);
            // search with 50 items max (so not filter metadata)
            this.mSearch.search(pQuery, this.mSearchVisibilityCtx, false, 50, []);
        };
        // get the document content
        TestMetadata.prototype.testDocumentIdConverter = function (pDocumentId, pDataSession) {
            // init the context just in case
            this.initCtx(pDataSession);
            this.mDocumentIdConverter.convert(pDocumentId, this.mConfVisibilityCtx);
        };
        // convert part instance ids => geometric instance ids
        TestMetadata.prototype.testPartInstanceConverter = function (pPartInstanceIds, pDataSession) {
            // init the context just in case
            this.initCtx(pDataSession);
            this.mPartInstanceConverter.convert(pPartInstanceIds);
        };
        // convert geometric instance ids => part instance ids with the current configuration
        TestMetadata.prototype.testGeometricInstanceConverter = function (pGeometricInstanceIds, pDataSession) {
            // init the context just in case
            this.initCtx(pDataSession);
            this.mGeometricInstanceConverter.convert(pGeometricInstanceIds, this.mConfVisibilityCtx);
        };
        // gets the id card of the given geometric instance id (picking)
        TestMetadata.prototype.getIdCard = function (pGeometricInstanceId, pDataSession) {
            // init the context just in case
            this.initCtx(pDataSession);
            // convert the geometric instance id to a list of part instance lIds
            var lGeometricInstanceIds = new Uint32Array(1);
            lGeometricInstanceIds[0] = pGeometricInstanceId;
            this.mGeometricConverterForIdCard.convert(lGeometricInstanceIds, this.mConfVisibilityCtx);
        };
        return TestMetadata;
    }());
    var lTestMetadata;
    // when the configuration is computed : hide all but the instances inside the given configuration
    onConfCtxReady = function (pEvent) {
        if (lInfiniteEngine) {
            var lConfCtx = pEvent.emitter;
            // everyone hidden
            lInfiniteEngine.updateGeometricStateForAll(infiniteapi.VisualStates.S_Hidden, infiniteapi.VisualStates.S_Hidden);
            var lGeometries = lConfCtx.getGeometricInstanceIds();
            if (lGeometries) {
                // and set the one visible
                lInfiniteEngine.updateGeometricState(lGeometries, infiniteapi.VisualStates.S_Hidden, ~infiniteapi.VisualStates.S_Hidden);
            }
        }
    };
    // lFirstExec is used to avoid to clear the selection if we are computing the content during a pick request
    var lFirstExec = true;
    // select items that are in the solver
    onGlobalSolverReady = function (pEvent) {
        var lSolver = pEvent.emitter;
        if (lFirstExec) {
            // do not clear selection if we have done nothing yet
            lFirstExec = false;
            if (lSolver.getFilterCount() === 0) {
                return;
            }
        }
        var lGeometries = lSolver.getGeometricInstanceIds();
        if (lInfiniteEngine) {
            // unselect every one
            lInfiniteEngine.updateGeometricStateForAll(infiniteapi.VisualStates.S_Selected, ~infiniteapi.VisualStates.S_Selected);
            if (lGeometries) {
                // select items inside the solver
                lInfiniteEngine.updateGeometricState(lGeometries, infiniteapi.VisualStates.S_Selected, infiniteapi.VisualStates.S_Selected);
            }
        }
    };
    // when the search is over, ghost everyone except the one inside the search result
    // and convert document ids to part instance ids
    onSearchReady = function (pEvent) {
        var lSearchInterface = (pEvent.emitter);
        if (lSearchInterface.isRunning()) {
            console.assert(false, 'this should not happen');
            return;
        }
        if (lSearchInterface.getLastError().length > 0) {
            return;
        }
        var lGeometricInstanceIds = lSearchInterface.getGeometricInstanceIds();
        if (lInfiniteEngine) {
            // ghost everyone except the one in the search result
            lInfiniteEngine.updateGeometricStateForAll(infiniteapi.VisualStates.S_Ghost, infiniteapi.VisualStates.S_Ghost);
            if (lGeometricInstanceIds) {
                lInfiniteEngine.updateGeometricState(lGeometricInstanceIds, infiniteapi.VisualStates.S_Ghost, ~infiniteapi.VisualStates.S_Ghost);
            }
        }
        var lSearchResult = lSearchInterface.getSearchDocuments();
        if (lSearchResult) {
            console.log('Search finished: ' + lSearchResult.length + ' result(s)');
            if (lSearchResult.length > 0) {
                // get the part instance ids of the given document
                var lPartId = lSearchResult[0].getDocumentId();
                console.log('Convert part to part instances: ' + lPartId);
                console.log(JSON.stringify(lSearchResult[0].getMetadataDocument()));
                lTestMetadata.testDocumentIdConverter(lPartId, lDataSession);
            }
        }
    };
    // we get the part instance ids from the search, do nothing but convert to geometric instance ids
    onDocumentIdConverterReady = function (pEvent) {
        var lDocumentIdConverter = (pEvent.emitter);
        if (lDocumentIdConverter.isRunning()) {
            console.assert(false, 'this should not happen');
            return;
        }
        if (lDocumentIdConverter.getLastError().length > 0) {
            return;
        }
        var lResult = lDocumentIdConverter.getConversionResult();
        if (lResult) {
            var lDocumentIdConverterInstances = lResult.getConvertedInstances();
            var lPartInstanceIds = new Uint32Array(lDocumentIdConverterInstances.length);
            for (var i = 0; i < lDocumentIdConverterInstances.length; ++i) {
                lPartInstanceIds[i] = lDocumentIdConverterInstances[i].getPartInstanceId();
            }
            console.log('parts converted');
            console.log('Convert part instances to geometric instance ids: ' + JSON.stringify(lPartInstanceIds));
            lTestMetadata.testPartInstanceConverter(lPartInstanceIds, lDataSession);
        }
    };
    // when the document id is cancelled (not likely wince we do not call DocumentIdConverterInterface.cancel)
    onDocumentIdConverterCancelled = function (_pEvent) {
        console.log(' Part converter cancelled');
    };
    // we have the geometric instance ids of first item of the search
    onPartInstanceConverterReady = function (pEvent) {
        var lPartInstanceConverter = (pEvent.emitter);
        if (lPartInstanceConverter.isRunning()) {
            console.assert(false, 'this should not happen');
            return;
        }
        console.log('part instances converted');
        if (lPartInstanceConverter.getLastError().length > 0) {
            return;
        }
        var lGeometricInstanceIds = lPartInstanceConverter.getGeometricInstanceIds();
        // these are the geometric instance ids of the first document in the search request
        // usually the search is done there, or before
        // for this sample, we test again the conversion to part instance ids, and make sure they are the same as 
        // the result from onDocumentIdConverterReady
        if (lGeometricInstanceIds) {
            console.log('Convert geometric instance ids to part instances : ' + JSON.stringify(lGeometricInstanceIds));
            // and make a dumb test, just for illustration purposes
            lTestMetadata.testGeometricInstanceConverter(lGeometricInstanceIds, lDataSession);
        }
    };
    // we have the part instance ids of first item of the search, again, this is a dumb test
    // only for illustration purpose : do not make such things in production !!!
    onGeometricInstanceConverterReady = function (pEvent) {
        var lGeometricInstanceConverter = (pEvent.emitter);
        if (lGeometricInstanceConverter.isRunning()) {
            console.assert(false, 'this should not happen');
            return;
        }
        console.log('geom ids converted');
        if (lGeometricInstanceConverter.getLastError().length > 0) {
            return;
        }
        var lPartInstanceIds = lGeometricInstanceConverter.getPartInstanceIds();
        console.log('Part instances result : ' + JSON.stringify(lPartInstanceIds));
    };
    // and now create the object to actually make the test :)
    lTestMetadata = new TestMetadata();
    // ####################################################################################################################################
    // ############################################ PICKING ###############################################################################
    // ####################################################################################################################################
    // let sPrimitiveId : number = 0;
    // the material ids for the primitives (box, lines, points)
    var lInnerColorPointMaterial = -1;
    var lOuterColorPointMaterial = -1;
    var lLast3dPos = new infiniteapi.Vector3();
    var lHalfExtent = new infiniteapi.Vector3();
    var lLastPointInstanceId = -1;
    var PickingTest;
    (function (PickingTest) {
        PickingTest[PickingTest["PT_Normal"] = 0] = "PT_Normal";
        PickingTest[PickingTest["PT_Points"] = 1] = "PT_Points";
        PickingTest[PickingTest["PT_Boxes"] = 2] = "PT_Boxes";
        PickingTest[PickingTest["PT_Lines"] = 3] = "PT_Lines";
    })(PickingTest || (PickingTest = {}));
    var sPickingTest = PickingTest.PT_Normal;
    if (window['pickingTest'] === 'point') {
        sPickingTest = PickingTest.PT_Points;
    }
    else if (window['pickingTest'] === 'box') {
        sPickingTest = PickingTest.PT_Boxes;
    }
    else if (window['pickingTest'] === 'line') {
        sPickingTest = PickingTest.PT_Lines;
    }
    // the rectangle to pick (if relevant)
    var lRubberBand = new infiniteapi.Rectangle();
    // store the last click to know the extent of the rectangle to pick
    var lLastClickEvent = {
        x: 0,
        y: 0,
        buttons: 0,
        button: 0,
        type: '',
        rubberInit: false
    };
    // what to do when we have the result from a pick ?
    onPicking = function (pEvent, _pCallbackData) {
        if (!lInfiniteEngine) {
            return;
        }
        var lAttachment = pEvent.attachments;
        var l3dAttachment = lAttachment.geometric;
        // the geometric instance id that was picked
        var lFirstGeometricId = 0;
        // and the resulting 3d position
        var l3dPosition = undefined;
        if (l3dAttachment !== undefined && l3dAttachment.length > 0) {
            lFirstGeometricId = l3dAttachment[0].instanceId;
            l3dPosition = l3dAttachment[0].position;
        }
        // Mid button click
        if (lLastClickEvent.button === 1) {
            if (!l3dPosition)
                return;
            // set the center coi
            lInfiniteEngine.getCameraManager().lookAt(l3dPosition);
        }
        // lef button click
        else if (lLastClickEvent.button === 0) {
            // if id double click
            if (lLastClickEvent.type === 'dblclick') {
                lInfiniteEngine.getCameraManager().fitGeometry(lFirstGeometricId);
            }
            else {
                switch (sPickingTest) {
                    case PickingTest.PT_Normal:
                        {
                            // clear selected state on pick
                            var lWasSelected = false;
                            if (lFirstGeometricId !== 0) {
                                // console.log(lAttachment.geometricPosition.x.toString() + " " + lAttachment.geometricPosition.y.toString() + " " + lAttachment.geometricPosition.z.toString());
                                var lGeomState = lInfiniteEngine.getGeometricState(lFirstGeometricId);
                                lWasSelected = ((lGeomState & infiniteapi.VisualStates.S_Selected) !== 0);
                            }
                            // multiple selection => no selection inversion
                            if (l3dAttachment && l3dAttachment.length > 1) {
                                lWasSelected = false;
                            }
                            // clear selected state
                            lInfiniteEngine.updateGeometricStateForAll(infiniteapi.VisualStates.S_Selected, ~infiniteapi.VisualStates.S_Selected);
                            // clear id card result frame
                            var lIdCardFrame = document.getElementById('idCardFrame');
                            lIdCardFrame.textContent = '';
                            if (lFirstGeometricId !== 0 && !lWasSelected && l3dAttachment) {
                                lLastClickedGeometricInstanceId = lFirstGeometricId;
                                // update visual state of selected item
                                var lIds = new Uint32Array(l3dAttachment.length);
                                for (var i = 0; i < l3dAttachment.length; ++i) {
                                    lIds[i] = l3dAttachment[i].instanceId;
                                }
                                // set all the selection as "selected"
                                lInfiniteEngine.updateGeometricState(lIds, infiniteapi.VisualStates.S_Selected, infiniteapi.VisualStates.S_Selected);
                                // get the corresponding id card of the first picked item (not all in case of multiple selection)
                                lTestMetadata.getIdCard(lFirstGeometricId, lDataSession);
                            }
                        }
                        break;
                    case PickingTest.PT_Points:
                        // create a point if a geometry was picked and if another point was not picked
                        if ((lAttachment.geometric && lAttachment.geometric.length > 0) && ((!lAttachment.point) || (lAttachment.point.length === 0))) {
                            if (lInnerColorPointMaterial === -1) {
                                lInnerColorPointMaterial = lInfiniteEngine.getPrimitiveManager().getMaterialManager().createMaterial(new infiniteapi.Vector4(1, 1, 1, 1));
                            }
                            if (lOuterColorPointMaterial === -1) {
                                lOuterColorPointMaterial = lInfiniteEngine.getPrimitiveManager().getMaterialManager().createMaterial(new infiniteapi.Vector4(59 / 255, 69 / 255, 132 / 255, 1));
                            }
                            lInfiniteEngine.getPrimitiveManager().getPointManager().createPoint(
                            // position
                            lAttachment.geometric[0].position, 
                            // sizes
                            40, 35, 
                            // colors
                            lInnerColorPointMaterial, lOuterColorPointMaterial);
                        }
                        // remove the point if a point was picked
                        else if ((lAttachment.point) && (lAttachment.point.length > 0)) {
                            lInfiniteEngine.getPrimitiveManager().getPointManager().removePoint(lAttachment.point[0].instanceId);
                        }
                        break;
                    case PickingTest.PT_Boxes:
                        if (((lAttachment.point) && (lAttachment.point.length > 0))) {
                            lInfiniteEngine.getPrimitiveManager().getPointManager().removePoint(lAttachment.point[0].instanceId);
                            if ((lLastPointInstanceId !== -1) && (lAttachment.point[0].instanceId !== lLastPointInstanceId)) {
                                lInfiniteEngine.getPrimitiveManager().getPointManager().removePoint(lLastPointInstanceId);
                            }
                            lLastPointInstanceId = -1;
                            return;
                        }
                        if (((lAttachment.box) && (lAttachment.box.length > 0))) {
                            lInfiniteEngine.getPrimitiveManager().getBoxManager().removeBox(lAttachment.box[0].instanceId);
                            if (lLastPointInstanceId !== -1) {
                                lInfiniteEngine.getPrimitiveManager().getPointManager().removePoint(lLastPointInstanceId);
                            }
                            lLastPointInstanceId = -1;
                            return;
                        }
                        if ((lAttachment.geometric && lAttachment.geometric.length > 0)) {
                            if (lLastPointInstanceId !== -1) {
                                lInfiniteEngine.getPrimitiveManager().getPointManager().removePoint(lLastPointInstanceId);
                                lLastPointInstanceId = -1;
                                var lDistance = lLast3dPos.distanceToVector(lAttachment.geometric[0].position);
                                // lDistance is the half diagonal of a cube
                                // cube extent is therefore lDistance * 2 / sqrt(3)
                                // cube half extent is therefore lDistance / sqrt(3)
                                lDistance /= Math.sqrt(3);
                                lHalfExtent.set(lDistance, lDistance, lDistance);
                                lInfiniteEngine.getPrimitiveManager().getBoxManager().createBox(lLast3dPos, lHalfExtent, lOuterColorPointMaterial, lInnerColorPointMaterial, 2);
                            }
                            else {
                                if (lInnerColorPointMaterial === -1) {
                                    lInnerColorPointMaterial = lInfiniteEngine.getPrimitiveManager().getMaterialManager().createMaterial(new infiniteapi.Vector4(1, 1, 1, 1));
                                }
                                if (lOuterColorPointMaterial === -1) {
                                    lOuterColorPointMaterial = lInfiniteEngine.getPrimitiveManager().getMaterialManager().createMaterial(new infiniteapi.Vector4(59 / 255, 69 / 255, 132 / 255, 1));
                                }
                                if (lLastPointInstanceId !== -1) {
                                    lInfiniteEngine.getPrimitiveManager().getPointManager().removePoint(lLastPointInstanceId);
                                }
                                lLastPointInstanceId = lInfiniteEngine.getPrimitiveManager().getPointManager().createPoint(
                                // position
                                lAttachment.geometric[0].position, 
                                // sizes
                                20, 16, 
                                // colors
                                lInnerColorPointMaterial, lOuterColorPointMaterial);
                                lAttachment.geometric[0].position.copy(lLast3dPos);
                            }
                        }
                        break;
                    case PickingTest.PT_Lines:
                    // falls through
                    default:
                        if (((lAttachment.point) && (lAttachment.point.length > 0))) {
                            lInfiniteEngine.getPrimitiveManager().getPointManager().removePoint(lAttachment.point[0].instanceId);
                            if ((lLastPointInstanceId !== -1) && (lAttachment.point[0].instanceId !== lLastPointInstanceId)) {
                                lInfiniteEngine.getPrimitiveManager().getPointManager().removePoint(lLastPointInstanceId);
                            }
                            lLastPointInstanceId = -1;
                            return;
                        }
                        if (((lAttachment.line) && (lAttachment.line.length > 0))) {
                            lInfiniteEngine.getPrimitiveManager().getLineManager().removeLine(lAttachment.line[0].instanceId);
                            if (lLastPointInstanceId !== -1) {
                                lInfiniteEngine.getPrimitiveManager().getPointManager().removePoint(lLastPointInstanceId);
                            }
                            lLastPointInstanceId = -1;
                            return;
                        }
                        if ((lAttachment.geometric && lAttachment.geometric.length > 0)) {
                            if (lLastPointInstanceId !== -1) {
                                lInfiniteEngine.getPrimitiveManager().getPointManager().removePoint(lLastPointInstanceId);
                                lLastPointInstanceId = -1;
                                lInfiniteEngine.getPrimitiveManager().getLineManager().createLine(lLast3dPos, lAttachment.geometric[0].position, lOuterColorPointMaterial, 4);
                            }
                            else {
                                if (lInnerColorPointMaterial === -1) {
                                    lInnerColorPointMaterial = lInfiniteEngine.getPrimitiveManager().getMaterialManager().createMaterial(new infiniteapi.Vector4(1, 1, 1, 1));
                                }
                                if (lOuterColorPointMaterial === -1) {
                                    lOuterColorPointMaterial = lInfiniteEngine.getPrimitiveManager().getMaterialManager().createMaterial(new infiniteapi.Vector4(59 / 255, 69 / 255, 132 / 255, 1));
                                }
                                if (lLastPointInstanceId !== -1) {
                                    lInfiniteEngine.getPrimitiveManager().getPointManager().removePoint(lLastPointInstanceId);
                                }
                                lLastPointInstanceId = lInfiniteEngine.getPrimitiveManager().getPointManager().createPoint(
                                // position
                                lAttachment.geometric[0].position, 
                                // sizes
                                20, 16, 
                                // colors
                                lInnerColorPointMaterial, lOuterColorPointMaterial);
                                lAttachment.geometric[0].position.copy(lLast3dPos);
                            }
                        }
                        break;
                }
            }
        }
    };
    // We pick a rectangle if initialized, else only a point
    var pickAtImpl = function () {
        if (lInfiniteEngine) {
            if ((!lLastClickEvent.rubberInit)
                || ((lRubberBand.width <= 3) && (lRubberBand.height <= 3))
                || (lRubberBand.width === 0)
                || (lRubberBand.height === 0)) {
                // pick the last point 
                lInfiniteEngine.pickAt(lLastClickEvent.x, lLastClickEvent.y);
            }
            else {
                // pick an area
                lInfiniteEngine.pickRect(lRubberBand);
            }
        }
        // and clear the rectangle
        lRubberBand.clear();
        lLastClickEvent.rubberInit = false;
    };
    // on left click => pick
    lView3D.addEventListener('click', function (event) {
        lLastClickEvent.x = event.offsetX;
        lLastClickEvent.y = event.offsetY;
        lLastClickEvent.button = event.button;
        lLastClickEvent.buttons = event.buttons;
        lLastClickEvent.type = event.type;
        // and click, but not if middle or right click
        if (lLastClickEvent.buttons === 0) {
            pickAtImpl();
        }
        lLastClickEvent.rubberInit = false;
    });
    // store the position to the first pick pos
    lView3D.addEventListener('mousedown', function (event) {
        lLastClickEvent.x = event.offsetX;
        lLastClickEvent.y = event.offsetY;
        lLastClickEvent.button = event.button;
        lLastClickEvent.buttons = event.buttons;
        lLastClickEvent.type = event.type;
        lLastClickEvent.rubberInit = false;
    });
    // when we release the mouse button, make a pick only on middle mouse if close to start pos
    // and hide the rubber band
    lView3D.addEventListener('mouseup', function (event) {
        if (lInfiniteEngine) {
            var lPrimitiveManager = lInfiniteEngine.getPrimitiveManager();
            lPrimitiveManager.getRubberBandManager().setRubberBandVisible(false);
        }
        if (lLastClickEvent.button === 1 && event.button === 1) {
            if (!lLastClickEvent.rubberInit) {
                lLastClickEvent.x = event.offsetX;
                lLastClickEvent.y = event.offsetY;
                lLastClickEvent.button = event.button;
                lLastClickEvent.buttons = event.buttons;
                lLastClickEvent.type = event.type;
                lLastClickEvent.rubberInit = false;
                pickAtImpl();
            }
        }
        lLastClickEvent.x = event.offsetX;
        lLastClickEvent.y = event.offsetY;
        lLastClickEvent.button = event.button;
        lLastClickEvent.buttons = event.buttons;
        lLastClickEvent.type = event.type;
    });
    // when we move the mouse, display the rubber band
    lView3D.addEventListener('mousemove', function (event) {
        if ((lLastClickEvent.button === 0) && (lLastClickEvent.buttons === 0)) {
            return;
        }
        if (lLastClickEvent.rubberInit || (Math.abs(lLastClickEvent.x - event.offsetX) > 3 || Math.abs(lLastClickEvent.y - event.offsetY) > 3)) {
            lRubberBand.x = Math.min(lLastClickEvent.x, event.offsetX);
            lRubberBand.y = Math.min(lLastClickEvent.y, event.offsetY);
            lRubberBand.width = Math.abs(lLastClickEvent.x - event.offsetX);
            lRubberBand.height = Math.abs(lLastClickEvent.y - event.offsetY);
            lLastClickEvent.rubberInit = true;
        }
        if (lLastClickEvent.buttons === 1 && event.buttons === 1) {
            if (lLastClickEvent.rubberInit && lInfiniteEngine) {
                var lPrimitiveManager = lInfiniteEngine.getPrimitiveManager();
                lPrimitiveManager.getRubberBandManager().setRubberBandRectangle(lRubberBand);
                lPrimitiveManager.getRubberBandManager().setRubberBandVisible(true);
            }
        }
    });
    lView3D.addEventListener('dblclick', function (event) {
        lLastClickEvent.x = event.offsetX;
        lLastClickEvent.y = event.offsetY;
        lLastClickEvent.button = event.button;
        lLastClickEvent.buttons = event.buttons;
        lLastClickEvent.type = event.type;
        lLastClickEvent.rubberInit = false;
        if (lInfiniteEngine) {
            lInfiniteEngine.pickAt(event.offsetX, event.offsetY);
        }
    });
    // ####################################################################################################################################
    // ############################################ IDCARD ################################################################################
    // ####################################################################################################################################
    onGetIdCardSuccess = function (pIdCard) {
        // create simple HTML elements to display the metadata
        var lIdCardFrame = document.getElementById('idCardFrame');
        lIdCardFrame.innerHTML = '';
        if (pIdCard['partmd'] && pIdCard['partmd'].length !== 0) {
            for (var i = 0; i < pIdCard['partmd'].length; ++i) {
                var lTable = document.createElement('table');
                var lMetadata = pIdCard['partmd'][i]['metadata'];
                for (var key in lMetadata) {
                    var tr = document.createElement('tr');
                    var tdKey = document.createElement('td');
                    tdKey.appendChild(document.createTextNode(key));
                    tr.appendChild(tdKey);
                    var tdValue = document.createElement('td');
                    tdValue.appendChild(document.createTextNode(lMetadata[key]));
                    tr.appendChild(tdValue);
                    lTable.appendChild(tr);
                }
                lIdCardFrame.appendChild(lTable);
            }
        }
    };
    // ####################################################################################################################################
    // ############################################ TESTS #################################################################################
    // ####################################################################################################################################
    // bind the keyboard :
    //    - space : reset camera and reset visual state (clear selection / ghost state)
    //    - F : cycle through some filtering / metadata tests
    //    - C : cycle through available configurations
    //    - S : trigger a search for "roue"
    //    - X : change the material of the last clicked geometry (red)
    document.addEventListener('keydown', function (event) {
        if (!lDMULoaded) {
            return;
        }
        switch (event.key) {
            case 'Space': // Space
                if (lInfiniteEngine) {
                    // reset camera
                    lInfiniteEngine.getCameraManager().resetCamera();
                    // clear selected and ghost state
                    lInfiniteEngine.updateGeometricStateForAll(infiniteapi.VisualStates.S_Selected | infiniteapi.VisualStates.S_Ghost, ~infiniteapi.VisualStates.S_Selected & ~infiniteapi.VisualStates.S_Ghost);
                }
                break;
            case 'f': // key_F
                // cycle through filtering tests
                lTestMetadata.testCtx(lDataSession);
                break;
            case 'c': // key_C
                // cycle through available configurations
                lTestMetadata.nextConfCtx(lDataSession);
                break;
            case 's': // key_S
                // trigger a search for "roue"
                lTestMetadata.search(window['test']['searchTerm'], lDataSession);
                break;
            case 'k': // Key_K
                if (lInfiniteEngine) {
                    // change / restore material of the last picked geometry
                    if (lLastMaterialGeometricInstanceId === 0) {
                        if (lLastClickedGeometricInstanceId !== 0) {
                            lLastMaterialGeometricInstanceId = lLastClickedGeometricInstanceId;
                            lInfiniteEngine.getMaterialManager().changeMaterialOfInstance(lLastClickedGeometricInstanceId, lRedMaterialId);
                        }
                    }
                    else {
                        lInfiniteEngine.getMaterialManager().restoreOriginalMaterialOfInstance(lLastMaterialGeometricInstanceId);
                        lLastMaterialGeometricInstanceId = 0;
                    }
                }
                break;
            default:
                break;
        }
    });
    // ####################################################################################################################################
    // ############################################ Resource controller status ###############################################################
    // ####################################################################################################################################
    var lResourceControllerState = -1; // set lResourceControllerState to invalid value
    // tells if the renderer is idle (i.e. no heavy calculation is done)
    var lIsRendererIdle = false;
    var resourceControllerWatcher = function () {
        var lNewState = infiniteapi.LoadingStates.S_AllLoaded;
        var lNewIsIdle = true;
        if (lInfiniteEngine) {
            lNewState = lInfiniteEngine.getResourceLoadingState();
            lNewIsIdle = lInfiniteEngine.isRendererIdle();
        }
        // if the loading state has changed, make a nice image
        if (lNewState !== lResourceControllerState) {
            var lRCWatcherDiv = document.getElementById('rcwatcher');
            lRCWatcherDiv.classList.remove('rcStateDownloading');
            lRCWatcherDiv.classList.remove('rcStateComplete');
            lRCWatcherDiv.classList.remove('rcStateOverBudget');
            var lTitle = '';
            switch (lNewState) {
                case infiniteapi.LoadingStates.S_Loading:
                    lRCWatcherDiv.classList.add('rcStateDownloading');
                    lTitle = 'Loading. Wait for it!';
                    break;
                case infiniteapi.LoadingStates.S_AllLoaded:
                    lRCWatcherDiv.classList.add('rcStateComplete');
                    lTitle = 'Loading complete. All geometries are loaded';
                    break;
                case infiniteapi.LoadingStates.S_OutOfBudget:
                // falls through
                default:
                    lRCWatcherDiv.classList.add('rcStateOverBudget');
                    lTitle = 'Loading stopped. Performance limit reached';
                    break;
            }
            lRCWatcherDiv.title = lTitle;
            lResourceControllerState = lNewState;
        }
        // if the renderer is working or idle
        if (lIsRendererIdle !== lNewIsIdle) {
            lIsRendererIdle = lNewIsIdle;
            var lEngineDiv = document.getElementById('engineIdle');
            if (!lEngineDiv)
                return;
            if (lIsRendererIdle) {
                lEngineDiv.classList.remove('engineRun');
                lEngineDiv.classList.add('engineStop');
            }
            else {
                lEngineDiv.classList.add('engineRun');
                lEngineDiv.classList.remove('engineStop');
            }
        }
    };
    // and each time the engine is updated, update the resource controller state
    infiniteapi.InfiniteFactory.GetInfiniteApiController().addEventListener(infiniteapi.InfiniteApiControllerInterfaceSignal.Tick, resourceControllerWatcher);
    // ####################################################################################################################################
    // ############################################ LOGIN / BUILD SELECTION ###############################################################
    // ####################################################################################################################################
    lStartFrame = document.getElementById('startFrame');
    lSelector = document.getElementById('buildSelectorFrame');
    lLoginFrame = document.getElementById('loginFrame');
    var lLoaderFrame = document.getElementById('loaderFrame');
    var lLoginButton = document.getElementById('loginButton');
    lView3D.style.display = 'none';
    lStartFrame.style.display = 'block';
    lSelector.style.display = 'none';
    lLoginFrame.style.display = 'block';
    lLoaderFrame.style.display = 'none';
    // Register click callback on login frame
    var AuthenticationServiceLogin = function () {
        // clear Error label
        var lErrorLabel = document.getElementById('loginError');
        lErrorLabel.textContent = '';
        // Check if a directory session exist
        if (window['authentication'] === 'popup') {
            // Build the redirect url
            var sRedirectUrl = window.location.href;
            var lOffset = sRedirectUrl.lastIndexOf('/');
            if (lOffset >= 0) {
                sRedirectUrl = sRedirectUrl.substring(0, lOffset) + '/authentication.html';
            }
            else {
                sRedirectUrl = window.location.origin + '/authentication.html';
            }
            // Open a new tab to handle authentication
            var sURL = lDirectorySession.getPopupBasedAuthenticationUrl(sRedirectUrl);
            if (typeof sURL === 'string') {
                if (sURL !== '' && sURL.indexOf('authenticate') >= 0) {
                    window.open(sURL);
                }
            }
        }
        else {
            var sRedirectUrl = window.location.origin + window.location.pathname;
            // if we have query parameters, we cannot register all existing query parameters in the list of allowed redirect url in the directory 
            // we must therefore use the same page without url to handle authentication and redirect after to the legit url
            // the legit url is stored in the session storage
            if (window.location.href.indexOf('?') >= 0) {
                // url with query parameters => store in session storage
                window.sessionStorage.setItem('redirecturl', window.location.href.split('#')[0]);
            }
            // get the authentication url to login
            var sURL = lDirectorySession.getSamePageAuthenticationUrl(sRedirectUrl);
            if (typeof sURL === 'string') {
                // navigate to the given authentication url
                window.location.href = sURL;
            }
            else {
                // something weird happen
                console.log('Error not expected !!! ' + sURL);
                window.sessionStorage.removeItem('redirecturl');
            }
        }
        lLoginButton.style.display = 'none';
        lLoaderFrame.style.display = 'block';
    };
    lLoginButton.addEventListener('click', AuthenticationServiceLogin);
    // Response of login, store all builds available for specified user
    var lProjectList;
    // Success callback on login
    var onLoginSuccess = function (pEvent, _pCallbackData) {
        createEngine(lMetadataManager);
        // Hide the loader frame
        lLoaderFrame.style.display = 'none';
        // hide the login frame
        var lInnerLoginFrame = document.getElementById('loginFrame');
        lInnerLoginFrame.style.display = 'none';
        // clear the HTML Select element
        var lInnerProjectSelector = document.getElementById('projectSelector');
        while (lInnerProjectSelector.firstChild) {
            lInnerProjectSelector.removeChild(lInnerProjectSelector.firstChild);
        }
        // Get the ConnectionData
        var lConnectionData = pEvent.attachments;
        // get the projects list
        lProjectList = lConnectionData.projects;
        // insert the project in HTML select element
        for (var lProjectId in lProjectList) {
            var lProjectInfo = lProjectList[lProjectId];
            var lHTMLOption = new Option(lProjectInfo.projectname, lProjectInfo.projectid, false, false);
            lInnerProjectSelector.add(lHTMLOption);
        }
        // trigger project selected change to update build list HTML element
        onProjectSelectedChanged();
        // Show the build list HTML element
        var lInnerSelector = document.getElementById('buildSelectorFrame');
        lInnerSelector.style.display = 'block';
    };
    // Failed callback on login
    var onLoginFailed = function (pEvent, _pCallbackData) {
        lLoaderFrame.style.display = 'none';
        var lErrorLabel = document.getElementById('loginError');
        var lError = pEvent.attachments;
        var lMessage = lError.message;
        var lErrorObject;
        try {
            lErrorObject = JSON.parse(lMessage);
        }
        catch (e) {
            lErrorObject = undefined;
        }
        if (lErrorObject && lErrorObject['error'] !== undefined) {
            lErrorLabel.textContent = 'Failed to login: ' + lErrorObject['more'].directoryerror;
        }
        else {
            lErrorLabel.textContent = 'Failed to login: ' + lError.message;
        }
    };
    // and register callbacks
    lDirectorySession.addEventListener(infiniteapi.DirectorySessionInterfaceSignal.LoginSuccess, onLoginSuccess);
    lDirectorySession.addEventListener(infiniteapi.DirectorySessionInterfaceSignal.LoginFailed, onLoginFailed);
    // ######################################################################################################################
    // ############################################     PROJECT SELECTOR     ################################################
    // ######################################################################################################################
    // On selected project changed
    onProjectSelectedChanged = function () {
        // clear the Build HTML select element
        var lBuildSelector = document.getElementById('buildSelector');
        while (lBuildSelector.firstChild) {
            lBuildSelector.removeChild(lBuildSelector.firstChild);
        }
        // Get the current selected project id
        var lInnerProjectSelector = document.getElementById('projectSelector');
        var lSelectedProjectId = '';
        if (lInnerProjectSelector.options[lInnerProjectSelector.selectedIndex]) {
            lSelectedProjectId = lInnerProjectSelector.options[lInnerProjectSelector.selectedIndex].value;
        }
        // Fill the buildSelector HTML Select element
        if (lProjectList) {
            // Get the list of available builds
            var lBuilds = lProjectList[lSelectedProjectId].builds;
            // foreach build insert in the buildSelector
            for (var lBuild in lBuilds) {
                // Get the Build data
                var lBuildData = lBuilds[lBuild];
                // Get the generation date
                var lGenerationDate = new Date(lBuildData.generationdate);
                // Create the build name
                var lBuildName = lBuildData.buildcomment + ' - ' + HumanizeDate(lGenerationDate);
                // Insert in HTML element
                var lHTMLOption = new Option(lBuildName, lBuild);
                lBuildSelector.add(lHTMLOption);
            }
        }
    };
    // Register "change" callback on project selector html element
    var lProjectSelector = document.getElementById('projectSelector');
    lProjectSelector.addEventListener('change', onProjectSelectedChanged);
    // what to do when the user is not doing anything, and is therefore "kicked" from the DataSessionInterface
    var onInactivityDetection = function () {
        console.log('Callback triggered when inactivity detected');
    };
    var onStartButton = function () {
        // Get the active project id
        // Get the active build id
        var lBuildSelector = document.getElementById('buildSelector');
        sBuildId = lBuildSelector.options[lBuildSelector.selectedIndex].value;
        // open the database
        lDataSession = lDirectorySession.createDataSession(sBuildId, lCache);
        if (lDataSession) {
            onOpenDBSuccess();
            // and register callbacks
            lDataSession.addEventListener(infiniteapi.DataSessionInterfaceSignal.IdleDataSession, onInactivityDetection);
            lDataSession.addEventListener(infiniteapi.DataSessionInterfaceSignal.DataSessionClosed, onCloseDBSuccess);
            lDataSession.addEventListener(infiniteapi.DataSessionInterfaceSignal.DMULoadingSuccess, onDMULoaded);
            lDataSession.addEventListener(infiniteapi.DataSessionInterfaceSignal.DMULoadingFailed, onOpenDBFailed);
            lDataSession.openDataSession();
        }
    };
    // Register click callback on start button html element
    var lStartButton = document.getElementById('startButton');
    lStartButton.addEventListener('click', onStartButton);
    // Register click callback on reset button
    var lResetButton = document.getElementById('resetbutton');
    lResetButton.addEventListener('click', function () {
        if (lDataSession) {
            lDataSession.closeDataSession();
        }
    });
    // Success callback on openDb
    onOpenDBSuccess = function () {
        var lInnerView3D = document.getElementById('rendering');
        var lInnerStartFrame = document.getElementById('startFrame');
        var lLoader = document.getElementById('loaderFrame');
        var lReset = document.getElementById('resetbutton');
        var lResource = document.getElementById('rcDiv');
        lInnerView3D.style.display = 'block';
        lInnerStartFrame.style.display = 'none';
        lLoader.style.display = 'block';
        lResource.style.display = 'block';
        lReset.style.display = 'block';
    };
    // Success callback on close database
    onCloseDBSuccess = function (_pEvent, _pCallbackData) {
        lTestMetadata.clearMetadata();
        var lInnerView3D = document.getElementById('rendering');
        var lInnerStartFrame = document.getElementById('startFrame');
        var lLoader = document.getElementById('loaderFrame');
        var lResource = document.getElementById('rcDiv');
        var lReset = document.getElementById('resetbutton');
        lInnerView3D.style.display = 'none';
        lInnerStartFrame.style.display = 'block';
        lLoader.style.display = 'none';
        lReset.style.display = 'none';
        lResource.style.display = 'none';
        lDMULoaded = false;
        lDataSession = undefined;
    };
    // Failed callback on openDb
    onOpenDBFailed = function (pEvent, _pCallbackData) {
        onDMULoadingFailed(pEvent, _pCallbackData);
        var lErrorLabel = document.getElementById('buildsSelectorError');
        lErrorLabel.textContent = 'Open database failed: ' + pEvent.attachments;
        lDMULoaded = false;
        lDataSession = undefined;
    };
    if (window['authentication'] !== 'popup') {
        // The directory must be provided with an authorize redirect url (dependent on url parameters)
        // it is better to register the base url, and redirect after to the correct 
        // url with the first parameters (this can be done with a SessionStorage)
        var lHash = window.location.hash;
        // but here, we handle hash, if hash then maybe we can authenticate, else do nothing
        if (lHash.length > 0) {
            // we can authenticate => hide login button
            lLoginButton.style.display = 'none';
            lLoaderFrame.style.display = 'block';
            // should we redirect to the url with query parameters ?
            var lSessionItem = window.sessionStorage.getItem('redirecturl');
            if (lSessionItem) {
                window.sessionStorage.removeItem('redirecturl');
                // navigate to the legit url (but with the hash)
                window.location.replace(lSessionItem + lHash);
            }
            else {
                // this is the legit url
                // remove hash (fully perhaps ?)
                if (window.history.replaceState) {
                    var uri = window.location.toString();
                    var cleanUri = uri.substring(0, uri.indexOf('#'));
                    window.history.replaceState({}, document.title, cleanUri);
                }
                else {
                    window.location.hash = '';
                }
                // and authenticate
                var lAuthenticationResult = lDirectorySession.setTokenFromHash(lHash);
                if (lAuthenticationResult !== infiniteapi.AuthenticationGetURLResult.AuthenticationPending) {
                    console.log('The token is not correct');
                    // do not be afraid, in this case the DirectorySessionInterfaceSignal.LoginFailed signal is sent
                }
            }
        }
    }
}