
function onLoad() {
	document.getElementById('scripterror').style.display = 'none';
	//try {
	let lDecode = window.location.hash.substring(1);
	const lLeft = 4 - (lDecode.length % 4);
	if (lLeft < 4) {
		for (let i = 0; i < lLeft; i++) {
			lDecode += "=";
		}
	}
	let lAuthRes = b64DecodeUtf8(lDecode);
	const lResult = JSON.parse(lAuthRes);

	document.getElementById('error').innerHTML = "";
	if (lResult['error']) {
		document.getElementById('error').innerHTML = lResult['error'];
		document.getElementById('error').style.display = '';
		document.getElementById('ko').style.display = '';
	}
	else {
		document.getElementById('ok').style.display = '';
		document.getElementById('hint').style.display = '';
		window.close();
	}
	/*} catch (error) {
		console.log(error);
		document.getElementById('error').innerHTML = "Failed to parse result";
		document.getElementById('error').style.display='';
	} */
};

const BASE64_DECODE_CHAR = { A: 0, B: 1, C: 2, D: 3, E: 4, F: 5, G: 6, H: 7, I: 8, J: 9, K: 10, L: 11, M: 12, N: 13, O: 14, P: 15, Q: 16, R: 17, S: 18, T: 19, U: 20, V: 21, W: 22, X: 23, Y: 24, Z: 25, a: 26, b: 27, c: 28, d: 29, e: 30, f: 31, g: 32, h: 33, i: 34, j: 35, k: 36, l: 37, m: 38, n: 39, o: 40, p: 41, q: 42, r: 43, s: 44, t: 45, u: 46, v: 47, w: 48, x: 49, y: 50, z: 51, '0': 52, '1': 53, '2': 54, '3': 55, '4': 56, '5': 57, '6': 58, '7': 59, '8': 60, '9': 61, '+': 62, '/': 63, '-': 62, '_': 63 };

function b64DecodeBytes(base64Str) {
	let v1, v2, v3, v4, bytes, index = 0;
	// eslint-disable-next-line prefer-destructuring
	let length = base64Str.length;

	if (base64Str.charAt(length - 2) === '=') {
		length -= 2;
	} else if (base64Str.charAt(length - 1) === '=') {
		length -= 1;
	}

	// 4 char to 3 bytes
	let lNbBytes = (length >> 2);
	const count = lNbBytes << 2;

	const remain = length - count;
	let i = 0;

	lNbBytes *= 3;
	if (remain === 2) {
		++lNbBytes;
	}
	else if (remain === 3) {
		lNbBytes += 2;
	}

	bytes = new Uint8Array(lNbBytes);

	while (i < count) {
		v1 = BASE64_DECODE_CHAR[base64Str.charAt(i++)];
		v2 = BASE64_DECODE_CHAR[base64Str.charAt(i++)];
		v3 = BASE64_DECODE_CHAR[base64Str.charAt(i++)];
		v4 = BASE64_DECODE_CHAR[base64Str.charAt(i++)];
		bytes[index++] = ((v1 << 2) | (v2 >>> 4)) & 255;
		bytes[index++] = ((v2 << 4) | (v3 >>> 2)) & 255;
		bytes[index++] = ((v3 << 6) | v4) & 255;
	}

	// remain bytes
	if (remain === 2) {
		v1 = BASE64_DECODE_CHAR[base64Str.charAt(i++)];
		v2 = BASE64_DECODE_CHAR[base64Str.charAt(i)];
		bytes[index] = ((v1 << 2) | (v2 >>> 4)) & 255;
	} else if (remain === 3) {
		v1 = BASE64_DECODE_CHAR[base64Str.charAt(i++)];
		v2 = BASE64_DECODE_CHAR[base64Str.charAt(i++)];
		v3 = BASE64_DECODE_CHAR[base64Str.charAt(i)];
		bytes[index++] = ((v1 << 2) | (v2 >>> 4)) & 255;
		bytes[index] = ((v2 << 4) | (v3 >>> 2)) & 255;
	}
	// eslint-disable-next-line spaced-comment
	/*#ifdef _DEBUG*/
	if (remain >= 2) {
		++index;
	}
	// eslint-disable-next-line no-console
	console.assert(index === (bytes.length));
	// eslint-disable-next-line spaced-comment
	/*#endif*/
	return bytes;
}
// from https://github.com/emn178/hi-base64/blob/master/src/base64.js
function b64DecodeUtf8(base64Str) {
	let str = '';
	const bytes = b64DecodeBytes(base64Str);
	// eslint-disable-next-line prefer-destructuring
	const length = bytes.length;
	let i = 0;
	let followingChars = 0;
	let b;
	let c;

	while (i < length) {
		b = bytes[i++];
		if (b <= 0x7f) {
			str += String.fromCharCode(b);
		}
		else {
			if (b > 0xbf && b <= 0xdf) {
				c = b & 0x1f;
				followingChars = 1;
			} else if (b <= 0xef) {
				c = b & 0x0f;
				followingChars = 2;
			} else if (b <= 0xf7) {
				c = b & 0x07;
				followingChars = 3;
			} else {
				return undefined;
			}
			for (let j = 0; j < followingChars; ++j) {
				b = bytes[i++];
				if (b < 0x80 || b > 0xbf) {
					return undefined;
				}
				c <<= 6;
				c += b & 0x3f;
			}
			if ((c >= 0xd800 && c <= 0xdfff) || (c > 0x10ffff)) {
				return undefined;
			}
			if (c <= 0xffff) {
				str += String.fromCharCode(c);
			} else {
				c -= 0x10000;
				str += String.fromCharCode((c >> 10) + 0xd800);
				str += String.fromCharCode((c & 0x3ff) + 0xdc00);
			}
		}
	}
	return str;
}

onLoad();