#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This program belongs to AKKODIS INGENIERIE PRODUIT SAS.
# It is considered a trade secret, and is not to be divulged or used
# by parties who have not received written authorization from the owner.
#

import shutil, os, stat,traceback, re, sys

srcFolder = None

# copy a file only if src is newer than dest
def copyFile (src, dest) :
	
	dest = os.path.normpath(dest)
	try:
		if not os.path.exists(src) :
			print('File %s not found' % os.path.abspath(src))
			return False
		if not os.path.islink(src):
			if os.path.exists(dest) and os.path.isdir(dest) :
					dest = os.path.join(dest, os.path.basename(src))
					
			outDir = os.path.dirname(dest)
			if (outDir != '') and (not os.path.exists(outDir)) :
				os.makedirs(outDir)
			copy = True
			pattern = '++'
			if os.path.exists(dest) :
				pattern = '##'
				if not os.path.isfile(dest) :
					print('Invalid destination %s' % os.path.abspath(dest))
					return False
				srcStat = os.stat(src)
				dstStat = os.stat(dest)
				if srcStat[stat.ST_MTIME] <= dstStat[stat.ST_MTIME]:
					copy = False
			if copy :
				shutil.copy2(src, dest)
				shutil.copystat(src, dest)
				#print('%s %s' % (pattern, os.path.basename(src)))
			return True
		else:
			srcPath = os.path.realpath(src)
			if os.path.exists(dest) and os.path.isdir(dest) :
					dest = os.path.join(dest, os.path.basename(src))
			destFile = os.path.join(os.path.dirname(dest),os.path.basename(srcPath))
			copyFile (srcPath, destFile)
			# and now create link
			if os.path.exists(dest) :
				os.unlink(dest)
			os.symlink(os.path.basename(destFile),os.path.abspath(dest))
			
	except Exception:
		print(traceback.format_exc())
		print('Cannot copy %s' % (os.path.basename(src)))
		return False


	
def usr_input(pMsg = ''):
	if sys.version_info >= (3, 0):
		return input(pMsg)
	else:
		return raw_input(pMsg)


# Copy folder, copy files only if src is newer than dest for each file
def copyFolder (src, dest, forWindows) :
	if not os.path.exists(src) :
		print('Folder %s not found' % src)
		sys.exit(1)
		
	excluded_win = [
	r".*\.git.*",
	r"^manual.*",
	r"^third-party/fonts.*",
	r"^third-party/.*couchdb.*\.tgz",
	r"^third-party/openjdk.*-linux.*",
	r"^third-party/otp.*",
	r"^[^/]*\.exe",
	r"^[^/]*\.py",
	r"^.*\.deb",
	".*PsConverter.*",
	r"3DJuump Infinite.*\.zip",
	]
	
	excluded_lin = excluded_win + [
	r".*\.exe",
	r".*\.dll",
	r".*\.msi",
	r".*createCertificate.zip",
	r"^third-party/vcresdists/.*",
	r"^third-party/openjdk.*",
	r"^third-party/elasticsearch.*",
	]
	
	excluded_win = excluded_win + [
		r".*\.sh",
		r".*\.so",
	]
	for index, item in enumerate(excluded_win):
		excluded_win[index] = re.compile(item,re.MULTILINE)
	
	for index, item in enumerate(excluded_lin):
		excluded_lin[index] = re.compile(item,re.MULTILINE)
	
	if forWindows :
		suffix = "-win"
	else :
		suffix = "-lin"
		
	allFoldersAndFiles = os.listdir(src)
	
	item = os.path.basename(src)
	
	dst = os.path.join(dest,item+suffix)
	srcFolder = src.replace("\\","/")
	if forWindows :
		excluded = excluded_win
	else :
		excluded = excluded_lin
				
	if os.path.exists(dst) :
		shutil.rmtree(dst)
	
	os.makedirs(dst)
	
	for path, dirs, files in os.walk(srcFolder) :
		relPath = os.path.abspath(path)
		relPath = relPath.replace("\\","/")
		relPath = relPath[len(srcFolder)+1:]
		
		excludedFolders = []
		for dir in dirs :
			if relPath != '' :
				curDir = relPath + '/' + dir
			else :
				curDir = dir
			
			for item in excluded :
				if not item.match(curDir) is None:
					excludedFolders.append(dir)
					break
		
		for item in excludedFolders :
			dirs.remove(item)
	
		for file in files :
			if relPath != '' :
				curFile = relPath + '/' + file
			else : 
				curFile = file
			shouldIgnore = False
			for item in excluded :
				if item.match(curFile) :
					shouldIgnore = True
					break
			if not shouldIgnore :
				copyFile(os.path.join(path, file), os.path.join(dst, relPath, file))
					


if __name__ == '__main__':
	# required : go to path of file
	os.chdir(os.path.dirname( os.path.realpath( __file__ ) ))
	
	lInput = usr_input("Windows version ? [Y/n]")
	
	forWindows = not(len(lInput) >= 1 and lInput[0].lower() != 'y')
		
	copyFolder(os.path.abspath("."),"..",forWindows)
