/* */

-- complain if script is sourced in psql, rather than via CREATE EXTENSION
\echo Use "CREATE EXTENSION infinitepgrangeoperators" to load this file. \quit

--########################################
------------------------------------------
-- aggregate function allowing to keep only one value, without adding it into GROUP BY, this function will ensure that all input are identical
------------------------------------------
--########################################
DROP FUNCTION IF EXISTS sv_agg_keep_single_transfn(internal, anyelement) CASCADE;
CREATE FUNCTION sv_agg_keep_single_transfn(internal, anyelement) RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_agg_keep_single_transfn';

DROP FUNCTION IF EXISTS sv_agg_keep_single_finalfn(internal, anyelement) CASCADE;
CREATE FUNCTION sv_agg_keep_single_finalfn(internal,anyelement) RETURNS anyelement
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_agg_keep_single_finalfn';

DROP FUNCTION IF EXISTS sv_agg_keep_single_combinefn(internal,internal);
CREATE FUNCTION sv_agg_keep_single_combinefn(internal,internal) RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_agg_keep_single_combinefn';
	
DROP FUNCTION IF EXISTS sv_agg_keep_single_serialfn(internal);
CREATE FUNCTION sv_agg_keep_single_serialfn(internal) RETURNS bytea
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_agg_keep_single_serialfn';
	
DROP FUNCTION IF EXISTS sv_agg_keep_single_deserialfn(bytea,internal);
CREATE FUNCTION sv_agg_keep_single_deserialfn(bytea,internal) RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_agg_keep_single_deserialfn';

CREATE AGGREGATE sv_agg_keep_single(anyelement)(
	SFUNC = sv_agg_keep_single_transfn,
	STYPE = internal,
	FINALFUNC = sv_agg_keep_single_finalfn,
	FINALFUNC_EXTRA,
	COMBINEFUNC = sv_agg_keep_single_combinefn,
	SERIALFUNC = sv_agg_keep_single_serialfn,
	DESERIALFUNC = sv_agg_keep_single_deserialfn,
	PARALLEL = SAFE
);



DROP FUNCTION IF EXISTS sv_agg_keep_single_ex_transfn(internal, anyelement, boolean) CASCADE;
CREATE FUNCTION sv_agg_keep_single_ex_transfn(internal, anyelement, boolean) RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_agg_keep_single_transfn';

DROP FUNCTION IF EXISTS sv_agg_keep_single_ex_finalfn(internal, anyelement, boolean) CASCADE;
CREATE FUNCTION sv_agg_keep_single_ex_finalfn(internal,anyelement, boolean) RETURNS anyelement
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_agg_keep_single_finalfn';

-- if boolean is false, no check will be performed to ensure that all entries are equal
-- the first aggregated value will be returned
-- to get 'first' or 'last' entry use ORDER BY xx DESC/ASC, take care it will disable // scan
CREATE AGGREGATE sv_agg_keep_single_ex(anyelement,boolean)(
	SFUNC = sv_agg_keep_single_ex_transfn,
	STYPE = internal,
	FINALFUNC = sv_agg_keep_single_ex_finalfn,
	FINALFUNC_EXTRA,
	COMBINEFUNC = sv_agg_keep_single_combinefn,
	SERIALFUNC = sv_agg_keep_single_serialfn,
	DESERIALFUNC = sv_agg_keep_single_deserialfn,
	PARALLEL = SAFE
);

--########################################
------------------------------------------
-- range array operators (union, intersection, exclusion)
------------------------------------------
--########################################

DROP FUNCTION IF EXISTS sv_int4range_union(int4[], int4[]);
CREATE FUNCTION sv_int4range_union(int4[], int4[]) RETURNS int4[]
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4range_union';

DROP FUNCTION IF EXISTS sv_int4range_intersection(int4[], int4[]);
CREATE FUNCTION sv_int4range_intersection(int4[], int4[]) RETURNS int4[]
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4range_intersection';
	
DROP FUNCTION IF EXISTS sv_int4range_exclusion(int4[], int4[]);
CREATE FUNCTION sv_int4range_exclusion(int4[], int4[]) RETURNS int4[]
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4range_exclusion';

DROP FUNCTION IF EXISTS sv_int4range_is_strictly_include(int4[], int4[]);
CREATE FUNCTION sv_int4range_is_strictly_include(int4[], int4[]) RETURNS BOOLEAN
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4range_is_strictly_include';

DROP FUNCTION IF EXISTS sv_int4range_is_overlap(int4[], int4[]);
CREATE FUNCTION sv_int4range_is_overlap(int4[], int4[]) RETURNS BOOLEAN
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4range_is_overlap';

--########################################
------------------------------------------	
-- aggregators
------------------------------------------	
--########################################

-- functions to aggregate range array with different operations
DROP FUNCTION IF EXISTS sv_int4range_op_transfn(internal, int2, int4[]);
CREATE FUNCTION sv_int4range_op_transfn(internal, int2, int4[]) RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL RESTRICTED
	AS 'MODULE_PATHNAME', 'sv_int4range_op_transfn';
	
DROP FUNCTION IF EXISTS sv_int4range_op_finalfn(internal);
CREATE FUNCTION sv_int4range_op_finalfn(internal) RETURNS int4[]
	LANGUAGE C 
	IMMUTABLE
	PARALLEL RESTRICTED
	AS 'MODULE_PATHNAME', 'sv_int4range_op_finalfn';

-- this aggregator is generally used on few rows so we did not make effort to make it fully parallel
CREATE AGGREGATE sv_int4range_op(int2,int4[])(
	SFUNC = sv_int4range_op_transfn,
	STYPE = internal,
	FINALFUNC = sv_int4range_op_finalfn,
	PARALLEL = RESTRICTED
);

-- functions to aggregate integer and return a minimum size mixed array containing both scalar and array or a rangeArray
DROP FUNCTION IF EXISTS sv_int4set_agg_transfn(internal, int4, "char");
CREATE FUNCTION sv_int4set_agg_transfn(internal, int4, "char") RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4set_agg_transfn_A';
	
DROP FUNCTION IF EXISTS sv_int4set_agg_transfn(internal, int4, int4, "char");
CREATE FUNCTION sv_int4set_agg_transfn(internal, int4, int4, "char") RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4set_agg_transfn_A';
	
DROP FUNCTION IF EXISTS sv_int4set_agg_transfn(internal, "char", int4[], "char");
CREATE FUNCTION sv_int4set_agg_transfn(internal, "char", int4[], "char") RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4set_agg_transfn_B';
	
DROP FUNCTION IF EXISTS sv_int4set_agg_finalfn(internal);
CREATE FUNCTION sv_int4set_agg_finalfn(internal) RETURNS int4[]
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4set_agg_finalfn';

DROP FUNCTION IF EXISTS sv_int4set_agg_combinefn(internal,internal);
CREATE FUNCTION sv_int4set_agg_combinefn(internal,internal) RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4set_agg_combinefn';
	
DROP FUNCTION IF EXISTS sv_int4set_agg_serialfn(internal);
CREATE FUNCTION sv_int4set_agg_serialfn(internal) RETURNS bytea
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4set_agg_serialfn';
	
DROP FUNCTION IF EXISTS sv_int4set_agg_deserialfn(bytea,internal);
CREATE FUNCTION sv_int4set_agg_deserialfn(bytea,internal) RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4set_agg_deserialfn';


DROP FUNCTION IF EXISTS sv_int4set_agg_optimized_transfn(internal, int4, int4, "char");
CREATE FUNCTION sv_int4set_agg_optimized_transfn(internal, int4, int4, "char") RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4set_agg_optimized_transfn_A';

DROP FUNCTION IF EXISTS sv_int4set_agg_optimized_transfn(internal, int4, int4, int4, "char");
CREATE FUNCTION sv_int4set_agg_optimized_transfn(internal, int4, int4, int4, "char") RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4set_agg_optimized_transfn_A';

DROP FUNCTION IF EXISTS sv_int4set_agg_optimized_transfn(internal, "char", int4[], int4, "char");
CREATE FUNCTION sv_int4set_agg_optimized_transfn(internal, "char", int4[], int4, "char") RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4set_agg_optimized_transfn_B';

DROP FUNCTION IF EXISTS sv_int4set_agg_optimized_finalfn(internal);
CREATE FUNCTION sv_int4set_agg_optimized_finalfn(internal) RETURNS int4[]
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4set_agg_optimized_finalfn';

DROP FUNCTION IF EXISTS sv_int4set_agg_optimized_combinefn(internal,internal);
CREATE FUNCTION sv_int4set_agg_optimized_combinefn(internal,internal) RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4set_agg_optimized_combinefn';
	
DROP FUNCTION IF EXISTS sv_int4set_agg_optimized_serialfn(internal);
CREATE FUNCTION sv_int4set_agg_optimized_serialfn(internal) RETURNS bytea
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4set_agg_optimized_serialfn';
	
DROP FUNCTION IF EXISTS sv_int4set_agg_optimized_deserialfn(bytea,internal);
CREATE FUNCTION sv_int4set_agg_optimized_deserialfn(bytea,internal) RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4set_agg_optimized_deserialfn';
	
-- first parameter is values to aggregate, second parameter is type of output
-- calling this function with asc ordered data could increase performances eg sv_int4_agg(min,max ORDER BY min)
CREATE AGGREGATE sv_int4_agg(int4, "char" )(
	SFUNC = sv_int4set_agg_transfn,
	STYPE = internal,
	FINALFUNC = sv_int4set_agg_finalfn,
	COMBINEFUNC = sv_int4set_agg_combinefn,
	SERIALFUNC = sv_int4set_agg_serialfn,
	DESERIALFUNC = sv_int4set_agg_deserialfn,
	PARALLEL = SAFE
);
CREATE AGGREGATE sv_int4_agg(int4, int4, "char" )(
	SFUNC = sv_int4set_agg_transfn,
	STYPE = internal,
	FINALFUNC = sv_int4set_agg_finalfn,
	COMBINEFUNC = sv_int4set_agg_combinefn,
	SERIALFUNC = sv_int4set_agg_serialfn,
	DESERIALFUNC = sv_int4set_agg_deserialfn,
	PARALLEL = SAFE
);
CREATE AGGREGATE sv_int4_agg("char",int4[], "char" )(
	SFUNC = sv_int4set_agg_transfn,
	STYPE = internal,
	FINALFUNC = sv_int4set_agg_finalfn,
	COMBINEFUNC = sv_int4set_agg_combinefn,
	SERIALFUNC = sv_int4set_agg_serialfn,
	DESERIALFUNC = sv_int4set_agg_deserialfn,
	PARALLEL = SAFE
);

-- those versions use a bitfield as temporary datastructure so it does no suite for very huge input ranges but work faster
-- those aggregators are more efficient when you want to aggregate once lot of values, to do multiple small aggreagation prefer using standard methods
-- first argument is values to aggregate, second argument is the max value of aggregate integers, third is kind of output 'm' for mixarray,'r' for rangearray, 's' for scalararray
CREATE AGGREGATE sv_int4_agg_optimized(int4, int4, "char")(
	SFUNC = sv_int4set_agg_optimized_transfn,
	STYPE = internal,
	FINALFUNC = sv_int4set_agg_optimized_finalfn,
	COMBINEFUNC = sv_int4set_agg_optimized_combinefn,
	SERIALFUNC = sv_int4set_agg_optimized_serialfn,
	DESERIALFUNC = sv_int4set_agg_optimized_deserialfn,
	PARALLEL = SAFE
);
-- first argument is min value of a range to aggregate,second argument is max value of a range to aggregate, third argument is the max value of aggregate integers, fourth is kind of output 'm' for mixarray,'r' for rangearray, 's' for scalararray
CREATE AGGREGATE sv_int4_agg_optimized(int4, int4, int4, "char")(
	SFUNC = sv_int4set_agg_optimized_transfn,
	STYPE = internal,
	FINALFUNC = sv_int4set_agg_optimized_finalfn,
	COMBINEFUNC = sv_int4set_agg_optimized_combinefn,
	SERIALFUNC = sv_int4set_agg_optimized_serialfn,
	DESERIALFUNC = sv_int4set_agg_optimized_deserialfn,
	PARALLEL = SAFE
);

CREATE AGGREGATE sv_int4_agg_optimized("char", int4[], int4, "char")(
	SFUNC = sv_int4set_agg_optimized_transfn,
	STYPE = internal,
	FINALFUNC = sv_int4set_agg_optimized_finalfn,
	COMBINEFUNC = sv_int4set_agg_optimized_combinefn,
	SERIALFUNC = sv_int4set_agg_optimized_serialfn,
	DESERIALFUNC = sv_int4set_agg_optimized_deserialfn,
	PARALLEL = SAFE
);

--########################################
------------------------------------------
-- array conversions scalar/range/mix
------------------------------------------
--########################################

DROP FUNCTION IF EXISTS sv_sort_int4(int4[]);
CREATE FUNCTION sv_sort_int4(int4[]) RETURNS int4[]
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_sort_int4';

-- functions to convert arrays
DROP FUNCTION IF EXISTS sv_int4setconv_int4("char",int4[],"char");
CREATE FUNCTION sv_int4setconv_int4("char",int4[],"char") RETURNS int4[]
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4setconv_int4';
	
-- this function will convert a range array into a range bitfield that could be used with operator 
DROP FUNCTION IF EXISTS sv_int4set2bitfield_int4("char",int4[]);
CREATE FUNCTION sv_int4set2bitfield_int4("char",int4[]) RETURNS bytea
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4set2bitfield_int4';

--########################################
------------------------------------------
-- range packing
------------------------------------------
--########################################
DROP FUNCTION IF EXISTS sv_range_pack(int4[]);
CREATE FUNCTION sv_range_pack(int4[]) RETURNS int8
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_range_pack';

DROP FUNCTION IF EXISTS sv_range_pack(int4,int4);
CREATE FUNCTION sv_range_pack(int4,int4) RETURNS int8
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_range_pack';
	
DROP FUNCTION IF EXISTS sv_rangepacked_lower(int8);
CREATE FUNCTION sv_rangepacked_lower(int8) RETURNS int4
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_rangepacked_lower';
	
DROP FUNCTION IF EXISTS sv_rangepacked_upper(int8);
CREATE FUNCTION sv_rangepacked_upper(int8) RETURNS int4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_rangepacked_upper';
	
--########################################
------------------------------------------
-- array helpers functions
------------------------------------------
--########################################
	
-- function that count scalar into a range array similar (but faster) to array_lenght(sv_range2scalar_int4(rangearray),1)
DROP FUNCTION IF EXISTS sv_count_scalar_in_int4set("char",int4[]);
CREATE FUNCTION sv_count_scalar_in_int4set("char",int4[]) RETURNS int4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_count_scalar_in_int4set';


-- function to test if input array as a value contained into bitfield
DROP FUNCTION IF EXISTS sv_int4set_overlap_bitfield("char",int4[], bytea);
CREATE FUNCTION sv_int4set_overlap_bitfield("char",int4[], bytea) RETURNS boolean
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4set_overlap_bitfield';

-- function to test if input array is strictly included into bitfield
DROP FUNCTION IF EXISTS sv_int4set_included_in_bitfield("char",int4[], bytea);
CREATE FUNCTION sv_int4set_included_in_bitfield("char",int4[], bytea) RETURNS boolean
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4set_included_in_bitfield';

-- functions to test if a scalar is into a range arrays
DROP FUNCTION IF EXISTS sv_int4_in_rangearray(int4, int4[]);
CREATE FUNCTION sv_int4_in_rangearray(int4, int4[]) RETURNS boolean
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4_in_rangearray';
	
CREATE OPERATOR ^@> (
	LEFTARG = int4,
	RIGHTARG = _int4,
	PROCEDURE = sv_int4_in_rangearray,
	--HASHES,
	RESTRICT = contsel,
	JOIN = contjoinsel
);

-- functions to test if a scalar is into a packed range
DROP FUNCTION IF EXISTS sv_int4_in_packedrange(int4, int8);
CREATE FUNCTION sv_int4_in_packedrange(int4, int8) RETURNS boolean
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4_in_packedrange';
	
CREATE OPERATOR ^@> (
	LEFTARG = int4,
	RIGHTARG = int8,
	PROCEDURE = sv_int4_in_packedrange,
	COMMUTATOR = *><,
	--HASHES,
	RESTRICT = contsel,
	JOIN = contjoinsel
);

-- function to test if a scalar is into a rangebitfield
DROP FUNCTION IF EXISTS sv_int4_in_rangebitfield(int4, bytea);
CREATE FUNCTION sv_int4_in_rangebitfield(int4, bytea) RETURNS boolean
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4_in_rangebitfield';
	
CREATE OPERATOR ^@> (
	LEFTARG = int4,
	RIGHTARG = bytea,
	PROCEDURE = sv_int4_in_rangebitfield,
	--HASHES,
	RESTRICT = contsel,
	JOIN = contjoinsel
);

-- functions to test if a range array overlaps an other one (at least one scalar in both arrays)
DROP FUNCTION IF EXISTS sv_int4range_overlap_rangearray(int4[], int4[]);
CREATE FUNCTION sv_int4range_overlap_rangearray(int4[], int4[]) RETURNS boolean
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4range_overlap_rangearray';
	
CREATE OPERATOR ^^@> (
	LEFTARG = int4[],
	RIGHTARG = int4[],
	PROCEDURE = sv_int4range_overlap_rangearray,
	COMMUTATOR = ^^@>,
	--HASHES,
	RESTRICT = contsel,
	JOIN = contjoinsel
);

-- function to test if a single packed range overlap a range array
DROP FUNCTION IF EXISTS sv_int4rangepacked_in_rangearray(int8, int4[]);
CREATE FUNCTION sv_int4rangepacked_in_rangearray(int8, int4[]) RETURNS boolean
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4rangepacked_in_rangearray';
	
CREATE OPERATOR *@> (
	LEFTARG = int8,
	RIGHTARG = _int4,
	PROCEDURE = sv_int4rangepacked_in_rangearray,
	--HASHES,
	RESTRICT = contsel,
	JOIN = contjoinsel
);

-- function to test if a single packed range overlap a rangebitfield
DROP FUNCTION IF EXISTS sv_int4rangepacked_in_rangebitfield(int8, bytea);
CREATE FUNCTION sv_int4rangepacked_in_rangebitfield(int8, bytea) RETURNS boolean
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4rangepacked_in_rangebitfield';
	
CREATE OPERATOR *@> (
	LEFTARG = int8,
	RIGHTARG = bytea,
	PROCEDURE = sv_int4rangepacked_in_rangebitfield,
	--HASHES,
	RESTRICT = contsel,
	JOIN = contjoinsel
);

-- function to test if a single packed range overlap an other one
DROP FUNCTION IF EXISTS sv_int4rangepacked_in_int4rangepacked(int8, int8);
CREATE FUNCTION sv_int4rangepacked_in_int4rangepacked(int8, int8) RETURNS boolean
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4rangepacked_in_int4rangepacked';
	
CREATE OPERATOR *@> (
	LEFTARG = int8,
	RIGHTARG = int8,
	PROCEDURE = sv_int4rangepacked_in_int4rangepacked,
	COMMUTATOR = *@>,
	--HASHES,
	RESTRICT = contsel,
	JOIN = contjoinsel
);

-- function to test if a single range in totaly included in an other one
DROP FUNCTION IF EXISTS sv_int4rangepacked_included_in_int4rangepacked(int8, int8);
CREATE FUNCTION sv_int4rangepacked_included_in_int4rangepacked(int8, int8) RETURNS boolean
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4rangepacked_included_in_int4rangepacked';

CREATE OPERATOR *>< (
	LEFTARG = int8,
	RIGHTARG = int8,
	PROCEDURE = sv_int4rangepacked_included_in_int4rangepacked,
	COMMUTATOR = ><*,
	--HASHES,
	RESTRICT = contsel,
	JOIN = contjoinsel
);


-- function to test if a single range contains totaly an other one
DROP FUNCTION IF EXISTS sv_int4rangepacked_contains_int4rangepacked(int8, int8);
CREATE FUNCTION sv_int4rangepacked_contains_int4rangepacked(int8, int8) RETURNS boolean
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4rangepacked_contains_int4rangepacked';

CREATE OPERATOR ><* (
	LEFTARG = int8,
	RIGHTARG = int8,
	PROCEDURE = sv_int4rangepacked_contains_int4rangepacked,
	COMMUTATOR = *><,
	--HASHES,
	RESTRICT = contsel,
	JOIN = contjoinsel
);

-- function to test if a single range contains totaly an other one
DROP FUNCTION IF EXISTS sv_int4rangepacked_contains_int4(int8, int4);
CREATE FUNCTION sv_int4rangepacked_contains_int4(int8, int4) RETURNS boolean
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_int4rangepacked_contains_int4';

CREATE OPERATOR *>< (
	LEFTARG = int8,
	RIGHTARG = int4,
	PROCEDURE = sv_int4rangepacked_contains_int4,
	COMMUTATOR = ^@>,
	--HASHES,
	RESTRICT = contsel,
	JOIN = contjoinsel
);


--########################################
------------------------------------------
-- binary extraction functions
------------------------------------------
--########################################

-- functions to extract int4 array from a custom bytea
DROP FUNCTION IF EXISTS sv_bytea2int4array(bytea);
CREATE FUNCTION sv_bytea2int4array(bytea) RETURNS real[]
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_bytea2int4array';

-- functions to extract float array from a custom bytea
DROP FUNCTION IF EXISTS sv_bytea2floatarray(bytea);
CREATE FUNCTION sv_bytea2floatarray(bytea) RETURNS real[]
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_bytea2floatarray';
	
-- functions to extract range array from a custom bytea that constains a mix array
DROP FUNCTION IF EXISTS sv_bytea2mix2rangearray(bytea);
CREATE FUNCTION sv_bytea2mix2rangearray(bytea) RETURNS int4[]
	LANGUAGE C
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_bytea2mix2rangearray';
	
--########################################
------------------------------------------	
-- range gist index
------------------------------------------
--########################################

CREATE OR REPLACE FUNCTION sv_gist_range_consistent(internal, internal, smallint, oid, internal)
RETURNS bool
AS 'MODULE_PATHNAME', 'sv_gist_range_consistent'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_range_union(internal, internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_range_union'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_range_compress_int4(internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_range_compress_int4'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_range_compress_int8(internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_range_compress_int8'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_range_decompress(internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_range_decompress'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_range_penalty(internal, internal, internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_range_penalty'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_range_picksplit(internal, internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_range_picksplit'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_range_same(internal, internal, internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_range_same'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_range_sortsupport(internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_range_sortsupport'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;


-- use this to create an index CREATE INDEX "gistrange" ON mytable USING gist("mycol" sv_gist_range_opclass)

-- this operator class is used to index int4 column an make range operations on it
CREATE OPERATOR CLASS sv_gist_range_int4_opclass
FOR TYPE int4 USING gist AS
	OPERATOR	1	^@> (int4, int4[]), -- is row value in range array
	OPERATOR 	2	^@> (int4, bytea), -- is row value in bitfield
	OPERATOR	3	^@> (int4, int8), -- is row value in given range ?
	FUNCTION	1	sv_gist_range_consistent (internal, internal, smallint, oid, internal),
	FUNCTION	2	sv_gist_range_union (internal, internal),
	FUNCTION	3	sv_gist_range_compress_int4 (internal),
	FUNCTION	4	sv_gist_range_decompress (internal),
	FUNCTION	5	sv_gist_range_penalty (internal, internal, internal),
	FUNCTION	6	sv_gist_range_picksplit (internal, internal),
	FUNCTION	7	sv_gist_range_same (internal, internal, internal),
	FUNCTION	11	sv_gist_range_sortsupport (internal),
	STORAGE 		int8;
	
-- this operator class is used to index int8 that represent packed range column an make range operations on it 
CREATE OPERATOR CLASS sv_gist_range_int4packedrange_opclass
FOR TYPE int8 USING gist AS
	OPERATOR	11	*@> (int8, int4[]), -- is row range array overlaps given range array ?
	OPERATOR	13	*@> (int8, int8), -- is row range array overlaps given range ?
	OPERATOR	14	*>< (int8, int8), -- is row value strictly included in given range ?
	OPERATOR	15	><* (int8, int8), -- does row value strictly contains given range ?
	OPERATOR	16	*>< (int8, int4), -- does row value strictly contains given scalar
	FUNCTION	1	sv_gist_range_consistent (internal, internal, smallint, oid, internal),
	FUNCTION	2	sv_gist_range_union (internal, internal),
	FUNCTION	3	sv_gist_range_compress_int8 (internal),
	FUNCTION	4	sv_gist_range_decompress (internal),
	FUNCTION	5	sv_gist_range_penalty (internal, internal, internal),
	FUNCTION	6	sv_gist_range_picksplit (internal, internal),
	FUNCTION	7	sv_gist_range_same (internal, internal, internal),
	FUNCTION	11	sv_gist_range_sortsupport (internal),
	STORAGE 		int8;
