/* */

-- complain if script is sourced in psql, rather than via CREATE EXTENSION
\echo Use "CREATE EXTENSION infinite3doperators" to load this file. \quit

-- this plugin uses bytea to represent OBB and AABB
-- OBB representation is [Ox,Oy,Oz,Ax,Ay,Az,Bx,By,Bz,Cx,Cy,Cz,Ex,Ey,Ez] where O is origin of the OBB and A,B,C normalized axis and E extends (half size) of the OBB
-- AABB representation is [Ax,Ay,Az,Bx,By,Bz] where A is min point of the AABB and B is max point of the AABB


-- ****************************************************************
-- ****************************************************************
-- AABB/OBB extract base methods
-- ****************************************************************
-- ****************************************************************
DROP FUNCTION IF EXISTS sv_extract_bb_float4( bytea );
CREATE FUNCTION sv_extract_bb_float4(bytea) RETURNS float4[]
 	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_extract_bb_float4';

DROP FUNCTION IF EXISTS sv_extract_bb_float8( bytea );
CREATE FUNCTION sv_extract_bb_float8(bytea) RETURNS float8[]
 	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_extract_bb_float8';

-- ****************************************************************
-- ****************************************************************
-- AABB base methods
-- ****************************************************************
-- ****************************************************************


-- AABB methods for float4

-- init functions

DROP FUNCTION IF EXISTS sv_aabb( float4[]);
CREATE FUNCTION sv_aabb(float4[]) RETURNS bytea
 	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_init_from_array';
	
-- return nth component of aabb min point
DROP FUNCTION IF EXISTS sv_aabbf_center(bytea,int);
CREATE FUNCTION sv_aabbf_center(bytea,int) RETURNS float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_center';
	
DROP FUNCTION IF EXISTS sv_aabbf_center(bytea);
CREATE FUNCTION sv_aabbf_center(bytea) RETURNS _float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_center';
	
-- return nth component of aabb min point
DROP FUNCTION IF EXISTS sv_aabbf_min(bytea,int);
CREATE FUNCTION sv_aabbf_min(bytea,int) RETURNS float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_min';
	
DROP FUNCTION IF EXISTS sv_aabbf_min(bytea);
CREATE FUNCTION sv_aabbf_min(bytea) RETURNS _float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_min';

-- return nth component of aabb max point
DROP FUNCTION IF EXISTS sv_aabbf_max(bytea,int);
CREATE FUNCTION sv_aabbf_max(bytea,int) RETURNS float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_max';
	
DROP FUNCTION IF EXISTS sv_aabbf_max(bytea);
CREATE FUNCTION sv_aabbf_max(bytea) RETURNS _float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_max';
	
-- return length of nth component of the aabb
DROP FUNCTION IF EXISTS sv_aabbf_size(bytea,int);
CREATE FUNCTION sv_aabbf_size(bytea,int) RETURNS float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_size';

DROP FUNCTION IF EXISTS sv_aabbf_size(bytea);
CREATE FUNCTION sv_aabbf_size(bytea) RETURNS _float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_size';
	
-- return length of nth component of the aabb
DROP FUNCTION IF EXISTS sv_aabbf_half_size(bytea,int);
CREATE FUNCTION sv_aabbf_half_size(bytea,int) RETURNS float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_half_size';

DROP FUNCTION IF EXISTS sv_aabbf_half_size(bytea);
CREATE FUNCTION sv_aabbf_half_size(bytea) RETURNS _float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_half_size';
	
DROP FUNCTION IF EXISTS sv_aabbf_diagonal_squared(bytea);
CREATE FUNCTION sv_aabbf_diagonal_squared(bytea) RETURNS float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_diagonal_squared';


-- AABB methods for float8

-- init functions

DROP FUNCTION IF EXISTS sv_aabb( float8[]);
CREATE FUNCTION sv_aabb(float8[]) RETURNS bytea
 	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_init_from_array';
	
-- return nth component of aabb min point
DROP FUNCTION IF EXISTS sv_aabbd_center(bytea,int);
CREATE FUNCTION sv_aabbd_center(bytea,int) RETURNS float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_center';
	
DROP FUNCTION IF EXISTS sv_aabbd_center(bytea);
CREATE FUNCTION sv_aabbd_center(bytea) RETURNS _float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_center';
	
-- return nth component of aabb min point
DROP FUNCTION IF EXISTS sv_aabbd_min(bytea,int);
CREATE FUNCTION sv_aabbd_min(bytea,int) RETURNS float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_min';
	
DROP FUNCTION IF EXISTS sv_aabbd_min(bytea);
CREATE FUNCTION sv_aabbd_min(bytea) RETURNS _float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_min';

-- return nth component of aabb max point
DROP FUNCTION IF EXISTS sv_aabbd_max(bytea,int);
CREATE FUNCTION sv_aabbd_max(bytea,int) RETURNS float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_max';
	
DROP FUNCTION IF EXISTS sv_aabbd_max(bytea);
CREATE FUNCTION sv_aabbd_max(bytea) RETURNS _float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_max';
	
-- return length of nth component of the aabb
DROP FUNCTION IF EXISTS sv_aabbd_size(bytea,int);
CREATE FUNCTION sv_aabbd_size(bytea,int) RETURNS float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_size';

DROP FUNCTION IF EXISTS sv_aabbd_size(bytea);
CREATE FUNCTION sv_aabbd_size(bytea) RETURNS _float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_size';
	
-- return length of nth component of the aabb
DROP FUNCTION IF EXISTS sv_aabbd_half_size(bytea,int);
CREATE FUNCTION sv_aabbd_half_size(bytea,int) RETURNS float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_half_size';

DROP FUNCTION IF EXISTS sv_aabbd_half_size(bytea);
CREATE FUNCTION sv_aabbd_half_size(bytea) RETURNS _float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_half_size';
	
DROP FUNCTION IF EXISTS sv_aabbd_diagonal_squared(bytea);
CREATE FUNCTION sv_aabbd_diagonal_squared(bytea) RETURNS float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_diagonal_squared';



-- return true if aabb is valid min<=max
DROP FUNCTION IF EXISTS sv_aabb_is_valid(bytea);
CREATE FUNCTION sv_aabb_is_valid(bytea) RETURNS boolean
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_is_valid';

DROP FUNCTION IF EXISTS sv_aabb_merge(bytea,bytea);
CREATE FUNCTION sv_aabb_merge(bytea,bytea) RETURNS bytea
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_merge';
	
DROP FUNCTION IF EXISTS sv_aabb_enlarge(bytea,float8);
CREATE FUNCTION sv_aabb_enlarge(bytea,float8) RETURNS bytea
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_enlarge';
	
-- ****************************************************************
-- ****************************************************************
-- AABB test methods
-- ****************************************************************
-- ****************************************************************
	
-- function to test if LEFT AABB is contained by RIGHT AABB
DROP FUNCTION IF EXISTS sv_aabb_contained_by(bytea, bytea);
CREATE FUNCTION sv_aabb_contained_by(bytea, bytea) RETURNS boolean
	LANGUAGE C 
	IMMUTABLE
	STRICT 
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_contained_by';
	
CREATE OPERATOR ||@>|| (
	LEFTARG = bytea,
	RIGHTARG = bytea,
	PROCEDURE = sv_aabb_contained_by,
	COMMUTATOR = ||<@||,
	--HASHES,
	RESTRICT = contsel,
	JOIN = contjoinsel
	);

-- function to test if LEFT AABB contains RIGHT AABB
DROP FUNCTION IF EXISTS sv_aabb_contains(bytea, bytea);
CREATE FUNCTION sv_aabb_contains(bytea, bytea) RETURNS boolean
	LANGUAGE C IMMUTABLE
	STRICT 
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_contains';

CREATE OPERATOR ||<@|| (
	LEFTARG = bytea,
	RIGHTARG = bytea,
	PROCEDURE = sv_aabb_contains,
	COMMUTATOR = ||@>||,
	--HASHES,
	RESTRICT = contsel,
	JOIN = contjoinsel
	);
	
-- function to test if LEFT AABB overlaps RIGHT AABB
DROP FUNCTION IF EXISTS sv_aabb_overlap(bytea, bytea);
CREATE FUNCTION sv_aabb_overlap(bytea, bytea) RETURNS boolean
	LANGUAGE C 
	IMMUTABLE
	STRICT 
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_overlap';

CREATE OPERATOR ||~~|| (
	LEFTARG = bytea,
	RIGHTARG = bytea,
	PROCEDURE = sv_aabb_overlap,
	COMMUTATOR = ||~~||,
	--HASHES,
	RESTRICT = contsel,
	JOIN = contjoinsel
	);

	
-- ****************************************************************
-- ****************************************************************
-- OBB methods
-- ****************************************************************
-- ****************************************************************

-- OBB methods for float4

DROP FUNCTION IF EXISTS sv_obb( float4[]);
CREATE FUNCTION sv_obb(float4[]) RETURNS bytea
 	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_init_from_array';

DROP FUNCTION IF EXISTS sv_obbf_center(bytea,int);
CREATE FUNCTION sv_obbf_center(bytea,int) RETURNS float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_center';
	
DROP FUNCTION IF EXISTS sv_obbf_center(bytea);
CREATE FUNCTION sv_obbf_center(bytea) RETURNS _float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_center';
	
DROP FUNCTION IF EXISTS sv_obbf_axis(bytea,int,int);
CREATE FUNCTION sv_obbf_axis(bytea,int,int) RETURNS float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_axis';
	
DROP FUNCTION IF EXISTS sv_obbf_axis(bytea,int);
CREATE FUNCTION sv_obbf_axis(bytea,int) RETURNS _float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_axis';

DROP FUNCTION IF EXISTS sv_obbf_size(bytea,int);
CREATE FUNCTION sv_obbf_size(bytea,int) RETURNS float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_size';
	
DROP FUNCTION IF EXISTS sv_obbf_size(bytea);
CREATE FUNCTION sv_obbf_size(bytea) RETURNS _float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_size';
	
DROP FUNCTION IF EXISTS sv_obbf_half_size(bytea,int);
CREATE FUNCTION sv_obbf_half_size(bytea,int) RETURNS float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_half_size';
	
DROP FUNCTION IF EXISTS sv_obbf_half_size(bytea);
CREATE FUNCTION sv_obbf_half_size(bytea) RETURNS _float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_half_size';
	
DROP FUNCTION IF EXISTS sv_obbf_diagonal_squared(bytea);
CREATE FUNCTION sv_obbf_diagonal_squared(bytea) RETURNS float4
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_diagonal_squared';


-- OBB methods for float8

DROP FUNCTION IF EXISTS sv_obb( float8[]);
CREATE FUNCTION sv_obb(float8[]) RETURNS bytea
 	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_init_from_array';

DROP FUNCTION IF EXISTS sv_obbd_center(bytea,int);
CREATE FUNCTION sv_obbd_center(bytea,int) RETURNS float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_center';
	
DROP FUNCTION IF EXISTS sv_obbd_center(bytea);
CREATE FUNCTION sv_obbd_center(bytea) RETURNS _float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_center';
	
DROP FUNCTION IF EXISTS sv_obbd_axis(bytea,int,int);
CREATE FUNCTION sv_obbd_axis(bytea,int,int) RETURNS float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_axis';
	
DROP FUNCTION IF EXISTS sv_obbd_axis(bytea,int);
CREATE FUNCTION sv_obbd_axis(bytea,int) RETURNS _float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_axis';

DROP FUNCTION IF EXISTS sv_obbd_size(bytea,int);
CREATE FUNCTION sv_obbd_size(bytea,int) RETURNS float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_size';
	
DROP FUNCTION IF EXISTS sv_obbd_size(bytea);
CREATE FUNCTION sv_obbd_size(bytea) RETURNS _float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_size';
	
DROP FUNCTION IF EXISTS sv_obbd_half_size(bytea,int);
CREATE FUNCTION sv_obbd_half_size(bytea,int) RETURNS float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_half_size';
	
DROP FUNCTION IF EXISTS sv_obbd_half_size(bytea);
CREATE FUNCTION sv_obbd_half_size(bytea) RETURNS _float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_half_size';
	
DROP FUNCTION IF EXISTS sv_obbd_diagonal_squared(bytea);
CREATE FUNCTION sv_obbd_diagonal_squared(bytea) RETURNS float8
	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_diagonal_squared';


-- ****************************************************************
-- ****************************************************************
-- OBB test methods
-- ****************************************************************
-- ****************************************************************	

	
-- ****************************************************************
-- ****************************************************************
-- methods to convert OBB, AABB
-- ****************************************************************
-- ****************************************************************
DROP FUNCTION IF EXISTS sv_obb_to_aabb( bytea);
CREATE FUNCTION sv_obb_to_aabb(bytea) RETURNS bytea
 	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_to_aabb';

DROP FUNCTION IF EXISTS sv_aabb_to_obb( bytea);
CREATE FUNCTION sv_aabb_to_obb(bytea) RETURNS bytea
 	LANGUAGE C 
	IMMUTABLE
	STRICT
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_to_obb';



-- ****************************************************************
-- ****************************************************************
-- methods to compare OBB and AABB
-- ****************************************************************
-- ****************************************************************	
-- function to test if LEFT OBB is contained by RIGHT CBB
DROP FUNCTION IF EXISTS sv_obb_contained_by_aabb(bytea, bytea);
CREATE FUNCTION sv_obb_contained_by_aabb(bytea, bytea) RETURNS boolean
	LANGUAGE C 
	IMMUTABLE
	STRICT 
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_contained_by_aabb';
	
CREATE OPERATOR //@>|| (
	LEFTARG = bytea,
	RIGHTARG = bytea,
	PROCEDURE = sv_obb_contained_by_aabb,
	COMMUTATOR = ||<@//,
	--HASHES,
	RESTRICT = contsel,
	JOIN = contjoinsel
	);

-- function to test if LEFT AABB contains RIGHT OBB
DROP FUNCTION IF EXISTS sv_aabb_contains_obb(bytea, bytea);
CREATE FUNCTION sv_aabb_contains_obb(bytea, bytea) RETURNS boolean
	LANGUAGE C 
	IMMUTABLE
	STRICT 
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_contains_obb';

CREATE OPERATOR ||<@// (
	LEFTARG = bytea,
	RIGHTARG = bytea,
	PROCEDURE = sv_aabb_contains_obb,
	COMMUTATOR = //@>||,
	--HASHES,
	RESTRICT = contsel,
	JOIN = contjoinsel
	);
	
-- function to test if LEFT OBB overlaps RIGHT AABB
DROP FUNCTION IF EXISTS sv_obb_overlap_aabb(bytea, bytea);
CREATE FUNCTION sv_obb_overlap_aabb(bytea, bytea) RETURNS boolean
	LANGUAGE C 
	IMMUTABLE
	STRICT 
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_obb_overlap_aabb';

CREATE OPERATOR //~~|| (
	LEFTARG = bytea,
	RIGHTARG = bytea,
	PROCEDURE = sv_obb_overlap_aabb,
	COMMUTATOR = ||~~//,
	--HASHES,
	RESTRICT = contsel,
	JOIN = contjoinsel
	);

-- function to test if LEFT AABB overlaps RIGHT OBB	
DROP FUNCTION IF EXISTS sv_aabb_overlap_obb(bytea, bytea);
CREATE FUNCTION sv_aabb_overlap_obb(bytea, bytea) RETURNS boolean
	LANGUAGE C
	IMMUTABLE
	STRICT 
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_aabb_overlap_obb';

CREATE OPERATOR ||~~// (
	LEFTARG = bytea,
	RIGHTARG = bytea,
	PROCEDURE = sv_aabb_overlap_obb,
	COMMUTATOR = //~~||,
	--HASHES,
	RESTRICT = contsel,
	JOIN = contjoinsel
	);

-- ****************************************************************
-- ****************************************************************
-- AABB / OBB aggregator
-- ****************************************************************
-- ****************************************************************

-- functions to aggregate aabb or obb result will always be an aabb
DROP FUNCTION IF EXISTS sv_bb_agg_transfn(internal, bytea);	
CREATE FUNCTION sv_bb_agg_transfn(internal, bytea) RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_bb_agg_transfn';
	
DROP FUNCTION IF EXISTS sv_bb_agg_finalfn(internal);
CREATE FUNCTION sv_bb_agg_finalfn(internal) RETURNS bytea
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_bb_agg_finalfn';

DROP FUNCTION IF EXISTS sv_bb_agg_combinefn(internal,internal);
CREATE FUNCTION sv_bb_agg_combinefn(internal,internal) RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_bb_agg_combinefn';
	
DROP FUNCTION IF EXISTS sv_bb_agg_serialfn(internal);
CREATE FUNCTION sv_bb_agg_serialfn(internal) RETURNS bytea
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_bb_agg_serialfn';
	
DROP FUNCTION IF EXISTS sv_bb_agg_deserialfn(bytea,internal);
CREATE FUNCTION sv_bb_agg_deserialfn(bytea,internal) RETURNS internal
	LANGUAGE C 
	IMMUTABLE
	PARALLEL SAFE
	AS 'MODULE_PATHNAME', 'sv_bb_agg_deserialfn';
	
CREATE AGGREGATE sv_bb_agg(bytea)(
	SFUNC = sv_bb_agg_transfn,
	STYPE = internal,
	FINALFUNC = sv_bb_agg_finalfn,
	COMBINEFUNC = sv_bb_agg_combinefn,
	SERIALFUNC = sv_bb_agg_serialfn,
	DESERIALFUNC = sv_bb_agg_deserialfn,
	PARALLEL = SAFE
);


-- ****************************************************************
-- ****************************************************************
-- 3D Gist
-- ****************************************************************
-- ****************************************************************
-- use this to create an index CREATE INDEX "myidx" ON mytable USING gist("mycol" sv_gist_3d_abbb_xxx_opclass)
-- this operator class is used to index 3d aabb/obb column 

-- GIST implementation methods for float4

CREATE OR REPLACE FUNCTION sv_gist_3d_float4_consistent(internal, internal, smallint, oid, internal)
RETURNS bool
AS 'MODULE_PATHNAME', 'sv_gist_3d_float4_consistent'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_3d_float4_union(internal, internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_3d_float4_union'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_3d_float4_compress_aabb(internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_3d_float4_compress_aabb'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_3d_float4_compress_obb(internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_3d_float4_compress_obb'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_3d_float4_decompress(internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_3d_float4_decompress'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_3d_float4_penalty(internal, internal, internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_3d_float4_penalty'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_3d_float4_picksplit(internal, internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_3d_float4_picksplit'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_3d_float4_same(internal, internal, internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_3d_float4_same'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_3d_float4_sortsupport(internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_3d_float4_sortsupport'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

-- GIST operator class for float4
-- WARNING consitent method is common for both aabb and obb index, be carefull when choosing strategy number

CREATE OPERATOR CLASS sv_gist_3d_abbb_float4_opclass
FOR TYPE bytea USING gist AS
	OPERATOR	1	||@>|| (bytea, bytea), -- is left AABB included in right AABB
	OPERATOR 	2	||~~|| (bytea, bytea), -- is left AABB overlap right AABB
	
	FUNCTION	1	sv_gist_3d_float4_consistent (internal, internal, smallint, oid, internal),
	FUNCTION	2	sv_gist_3d_float4_union (internal, internal),
	FUNCTION	3	sv_gist_3d_float4_compress_aabb (internal),
	FUNCTION	4	sv_gist_3d_float4_decompress (internal),
	FUNCTION	5	sv_gist_3d_float4_penalty (internal, internal, internal),
	FUNCTION	6	sv_gist_3d_float4_picksplit (internal, internal),
	FUNCTION	7	sv_gist_3d_float4_same (internal, internal, internal),
	FUNCTION	11	sv_gist_3d_float4_sortsupport (internal),
	STORAGE 		bytea;
	
CREATE OPERATOR CLASS sv_gist_3d_obb_float4_opclass
FOR TYPE bytea USING gist AS
	OPERATOR	11	//@>|| (bytea, bytea), -- is left OBB included in right AABB
	OPERATOR 	12	//~~|| (bytea, bytea), -- is left OBB overlap right AABB
	
	
	FUNCTION	1	sv_gist_3d_float4_consistent (internal, internal, smallint, oid, internal),
	FUNCTION	2	sv_gist_3d_float4_union (internal, internal),
	FUNCTION	3	sv_gist_3d_float4_compress_obb (internal),
	FUNCTION	4	sv_gist_3d_float4_decompress (internal),
	FUNCTION	5	sv_gist_3d_float4_penalty (internal, internal, internal),
	FUNCTION	6	sv_gist_3d_float4_picksplit (internal, internal),
	FUNCTION	7	sv_gist_3d_float4_same (internal, internal, internal),
	FUNCTION	11	sv_gist_3d_float4_sortsupport (internal),
	STORAGE 		bytea;


-- GIST implementation methods for float8

CREATE OR REPLACE FUNCTION sv_gist_3d_float8_consistent(internal, internal, smallint, oid, internal)
RETURNS bool
AS 'MODULE_PATHNAME', 'sv_gist_3d_float8_consistent'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_3d_float8_union(internal, internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_3d_float8_union'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_3d_float8_compress_aabb(internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_3d_float8_compress_aabb'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_3d_float8_compress_obb(internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_3d_float8_compress_obb'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_3d_float8_decompress(internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_3d_float8_decompress'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_3d_float8_penalty(internal, internal, internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_3d_float8_penalty'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_3d_float8_picksplit(internal, internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_3d_float8_picksplit'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_3d_float8_same(internal, internal, internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_3d_float8_same'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

CREATE OR REPLACE FUNCTION sv_gist_3d_float8_sortsupport(internal)
RETURNS internal
AS 'MODULE_PATHNAME', 'sv_gist_3d_float8_sortsupport'
LANGUAGE C 
IMMUTABLE
STRICT
PARALLEL SAFE;

-- GIST operator class for float8
-- WARNING consitent method is common for both aabb and obb index, be carefull when choosing strategy number

CREATE OPERATOR CLASS sv_gist_3d_abbb_float8_opclass
FOR TYPE bytea USING gist AS
	OPERATOR	1	||@>|| (bytea, bytea), -- is left AABB included in right AABB
	OPERATOR 	2	||~~|| (bytea, bytea), -- is left AABB overlap right AABB
	
	FUNCTION	1	sv_gist_3d_float8_consistent (internal, internal, smallint, oid, internal),
	FUNCTION	2	sv_gist_3d_float8_union (internal, internal),
	FUNCTION	3	sv_gist_3d_float8_compress_aabb (internal),
	FUNCTION	4	sv_gist_3d_float8_decompress (internal),
	FUNCTION	5	sv_gist_3d_float8_penalty (internal, internal, internal),
	FUNCTION	6	sv_gist_3d_float8_picksplit (internal, internal),
	FUNCTION	7	sv_gist_3d_float8_same (internal, internal, internal),
	FUNCTION	11	sv_gist_3d_float8_sortsupport (internal),
	STORAGE 		bytea;
	
CREATE OPERATOR CLASS sv_gist_3d_obb_float8_opclass
FOR TYPE bytea USING gist AS
	OPERATOR	11	//@>|| (bytea, bytea), -- is left OBB included in right AABB
	OPERATOR 	12	//~~|| (bytea, bytea), -- is left OBB overlap right AABB
	
	
	FUNCTION	1	sv_gist_3d_float8_consistent (internal, internal, smallint, oid, internal),
	FUNCTION	2	sv_gist_3d_float8_union (internal, internal),
	FUNCTION	3	sv_gist_3d_float8_compress_obb (internal),
	FUNCTION	4	sv_gist_3d_float8_decompress (internal),
	FUNCTION	5	sv_gist_3d_float8_penalty (internal, internal, internal),
	FUNCTION	6	sv_gist_3d_float8_picksplit (internal, internal),
	FUNCTION	7	sv_gist_3d_float8_same (internal, internal, internal),
	FUNCTION	11	sv_gist_3d_float8_sortsupport (internal),
	STORAGE 		bytea;

